/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.authenticator;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.naming.AuthenticationException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfoOidcAuthenticator
extends InitializableObject
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(UserInfoOidcAuthenticator.class);
    private OidcConfiguration configuration;

    public UserInfoOidcAuthenticator() {
    }

    public UserInfoOidcAuthenticator(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    public void validate(Credentials cred, WebContext context, SessionStore sessionStore) {
        this.init();
        TokenCredentials credentials = (TokenCredentials)cred;
        OidcProfileDefinition profileDefinition = new OidcProfileDefinition();
        OidcProfile profile = (OidcProfile)profileDefinition.newProfile(new Object[0]);
        BearerAccessToken accessToken = new BearerAccessToken(credentials.getToken());
        profile.setAccessToken((AccessToken)accessToken);
        JWTClaimsSet userInfoClaimsSet = this.fetchOidcProfile(accessToken);
        Optional.ofNullable(userInfoClaimsSet).map(JWTClaimsSet::getClaims).ifPresent(claims -> this.collectProfileClaims(profileDefinition, profile, (Map<String, Object>)claims));
        profile.setTokenExpirationAdvance(this.configuration.getTokenExpirationAdvance());
        credentials.setUserProfile((UserProfile)profile);
    }

    protected void collectProfileClaims(OidcProfileDefinition profileDefinition, OidcProfile profile, Map<String, Object> claims) {
        claims.forEach((name, value) -> {
            if (this.configuration.getMappedClaims().containsKey(name)) {
                String actualName = this.configuration.getMappedClaims().get(name);
                logger.debug("Mapping claim {} as {} with values {} to profile", new Object[]{name, actualName, value});
                profileDefinition.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, actualName, value);
            } else {
                logger.debug("Adding claim {} to profile with values {}", name, value);
                profileDefinition.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, (String)name, value);
            }
        });
    }

    private JWTClaimsSet fetchOidcProfile(BearerAccessToken accessToken) {
        UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.findProviderMetadata().getUserInfoEndpointURI(), accessToken);
        HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
        this.configuration.configureHttpRequest(userInfoHttpRequest);
        try {
            HTTPResponse httpResponse = userInfoHttpRequest.send();
            logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject().toJSONObject());
                throw new AuthenticationException();
            }
            UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
            JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
            return userInfoClaimsSet;
        }
        catch (ParseException | IOException | java.text.ParseException | AuthenticationException e) {
            throw new TechnicalException(e);
        }
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }
}

