/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.credentials.extractor.OidcExtractor;
import org.pac4j.oidc.logout.OidcLogoutActionBuilder;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.creator.OidcProfileCreator;
import org.pac4j.oidc.redirect.OidcRedirectionActionBuilder;

public class OidcClient
extends IndirectClient {
    private OidcConfiguration configuration;

    public OidcClient() {
    }

    public OidcClient(OidcConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    protected void beforeInternalInit() {
        super.beforeInternalInit();
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    protected void internalInit() {
        this.configuration.init();
        this.defaultRedirectionActionBuilder(new OidcRedirectionActionBuilder(this));
        this.defaultCredentialsExtractor(new OidcExtractor(this.configuration, this));
        this.defaultAuthenticator(new OidcAuthenticator(this.configuration, this));
        this.defaultProfileCreator(new OidcProfileCreator(this.configuration, this));
        this.defaultLogoutActionBuilder(new OidcLogoutActionBuilder(this.configuration));
    }

    public Optional<UserProfile> renewUserProfile(UserProfile profile, WebContext context, SessionStore sessionStore) {
        OidcProfile oidcProfile = (OidcProfile)profile;
        RefreshToken refreshToken = oidcProfile.getRefreshToken();
        if (refreshToken != null) {
            OidcCredentials credentials = new OidcCredentials();
            credentials.setRefreshToken(refreshToken);
            OidcAuthenticator authenticator = new OidcAuthenticator(this.getConfiguration(), this);
            authenticator.refresh(credentials);
            if (credentials.getAccessToken() != null) {
                return this.getUserProfile(credentials, context, sessionStore);
            }
        }
        return Optional.empty();
    }

    public void notifySessionRenewal(String oldSessionId, WebContext context, SessionStore sessionStore) {
        this.configuration.findLogoutHandler().renewSession(oldSessionId, context, sessionStore);
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectionActionBuilder", this.getRedirectionActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.getLogoutActionBuilder(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration});
    }
}

