/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.config.AzureAdOidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;

public class AzureAd2OidcConfiguration
extends AzureAdOidcConfiguration {
    public AzureAd2OidcConfiguration() {
    }

    public AzureAd2OidcConfiguration(OidcConfiguration oidcConfiguration) {
        super(oidcConfiguration);
    }

    @Override
    protected void internalInit() {
        if (CommonHelper.isBlank((String)this.getTenant())) {
            this.setTenant("common");
        }
        super.internalInit();
    }

    @Override
    public String getDiscoveryURI() {
        return "https://login.microsoftonline.com/" + this.getTenant() + "/v2.0/.well-known/openid-configuration";
    }

    @Override
    public String makeOauth2TokenRequest(String refreshToken) {
        String scope = this.getScope();
        if (CommonHelper.isBlank((String)scope)) {
            scope = "openid profile email";
        }
        String payload = HttpUtils.encodeQueryParam((String)"client_id", (String)this.getClientId()) + "&" + HttpUtils.encodeQueryParam((String)"client_secret", (String)this.getSecret()) + "&" + HttpUtils.encodeQueryParam((String)"grant_type", (String)"refresh_token") + "&" + HttpUtils.encodeQueryParam((String)"refresh_token", (String)refreshToken) + "&" + HttpUtils.encodeQueryParam((String)"tenant", (String)this.getTenant()) + "&" + HttpUtils.encodeQueryParam((String)"scope", (String)scope);
        return payload;
    }
}

