/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.jwt.AbstractJwtProfile;

public class OidcProfile
extends AbstractJwtProfile {
    private static final long serialVersionUID = -52855988661742374L;

    public String getFirstName() {
        return (String)this.getAttribute("given_name");
    }

    public String getMiddleName() {
        return (String)this.getAttribute("middle_name");
    }

    public String getDisplayName() {
        return (String)this.getAttribute("name");
    }

    public String getNickname() {
        return (String)this.getAttribute("nickname");
    }

    public String getUsername() {
        return (String)this.getAttribute("preferred_username");
    }

    public URI getPictureUrl() {
        return (URI)this.getAttribute("picture");
    }

    public URI getProfileUrl() {
        return (URI)this.getAttribute("profile");
    }

    public String getLocation() {
        return (String)this.getAttribute("zoneinfo");
    }

    public Boolean getEmailVerified() {
        return (Boolean)this.getAttribute("email_verified");
    }

    public String getPhoneNumber() {
        return (String)this.getAttribute("phone_number");
    }

    public Boolean getPhoneNumberVerified() {
        return (Boolean)this.getAttribute("phone_number_verified");
    }

    public Date getUpdatedAt() {
        return this.getAttributeAsDate("updated_at");
    }

    public Date getAuthTime() {
        return (Date)this.getAttribute("auth_time");
    }

    public String getNonce() {
        return (String)this.getAttribute("nonce");
    }

    public String getAcr() {
        return (String)this.getAttribute("acr");
    }

    public Object getAmr() {
        return this.getAttribute("amr");
    }

    public String getAzp() {
        return (String)this.getAttribute("azp");
    }

    public void setAccessToken(AccessToken accessToken) {
        this.addAttribute("access_token", accessToken);
        if (accessToken != null) {
            if (accessToken.getLifetime() != 0L) {
                this.addAttribute("expiration", Date.from(Instant.now().plusSeconds(accessToken.getLifetime())));
            } else {
                Date exp = null;
                try {
                    JWTClaimsSet jwtClaimsSet = JWTParser.parse((String)accessToken.getValue()).getJWTClaimsSet();
                    if (jwtClaimsSet != null) {
                        exp = jwtClaimsSet.getExpirationTime();
                    }
                }
                catch (ParseException e) {
                    this.logger.trace(e.getMessage(), (Throwable)e);
                }
                if (exp != null) {
                    this.addAttribute("expiration", exp);
                }
            }
        }
    }

    public AccessToken getAccessToken() {
        return (AccessToken)this.getAttribute("access_token");
    }

    public String getIdTokenString() {
        return (String)this.getAttribute("id_token");
    }

    public void setIdTokenString(String idToken) {
        this.addAttribute("id_token", idToken);
    }

    public JWT getIdToken() {
        if (this.getIdTokenString() != null) {
            try {
                return JWTParser.parse((String)this.getIdTokenString());
            }
            catch (ParseException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        return null;
    }

    public RefreshToken getRefreshToken() {
        return (RefreshToken)this.getAttribute("refresh_token");
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.addAttribute("refresh_token", refreshToken);
    }

    public void removeLoginData() {
        this.removeAttribute("id_token");
        this.removeAttribute("access_token");
        this.removeAttribute("refresh_token");
    }

    public int getTokenExpirationAdvance() {
        Object tokenExpirationAdvance = this.getAttribute("token_expiration_advance");
        if (tokenExpirationAdvance != null) {
            if (tokenExpirationAdvance instanceof Long) {
                return ((Long)tokenExpirationAdvance).intValue();
            }
            if (tokenExpirationAdvance instanceof Integer) {
                return (Integer)tokenExpirationAdvance;
            }
        }
        return -1;
    }

    public void setTokenExpirationAdvance(int tokenExpirationAdvance) {
        this.addAttribute("token_expiration_advance", tokenExpirationAdvance);
    }

    public Date getExpiration() {
        return this.getAttributeAsDate("expiration");
    }

    public boolean isExpired() {
        int tokenExpirationAdvance = this.getTokenExpirationAdvance();
        if (tokenExpirationAdvance < 0) {
            tokenExpirationAdvance = 0;
        }
        return this.getExpiration() != null && this.getExpiration().toInstant().isBefore(Instant.now().plusSeconds(tokenExpirationAdvance));
    }
}

