/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.RandomValueGenerator;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.oidc.profile.creator.TokenValidator;
import org.pac4j.oidc.util.SessionStoreValueRetriever;
import org.pac4j.oidc.util.ValueRetriever;

public class OidcConfiguration
extends BaseClientConfiguration {
    public static final String SCOPE = "scope";
    public static final String CUSTOM_PARAMS = "custom_params";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String RESPONSE_MODE = "response_mode";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CLIENT_ID = "client_id";
    public static final String STATE = "state";
    public static final String MAX_AGE = "max_age";
    public static final String PROMPT = "prompt";
    public static final String NONCE = "nonce";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final List<ResponseType> AUTHORIZATION_CODE_FLOWS = Collections.unmodifiableList(Arrays.asList(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE})));
    public static final List<ResponseType> IMPLICIT_FLOWS = Collections.unmodifiableList(Arrays.asList(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}), new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.TOKEN})));
    public static final List<ResponseType> HYBRID_CODE_FLOWS = Collections.unmodifiableList(Arrays.asList(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN}), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN}), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.TOKEN})));
    public static final int DEFAULT_MAX_CLOCK_SKEW = 30;
    public static final int DEFAULT_TOKEN_EXPIRATION_ADVANCE = 0;
    private String clientId;
    private String secret;
    private String discoveryURI;
    private String scope;
    private Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private boolean useNonce;
    private boolean disablePkce = false;
    private CodeChallengeMethod pkceMethod;
    private JWSAlgorithm preferredJwsAlgorithm;
    private Integer maxAge;
    private int maxClockSkew = 30;
    private ResourceRetriever resourceRetriever;
    private OIDCProviderMetadata providerMetadata;
    private ResponseType responseType = AUTHORIZATION_CODE_FLOWS.get(0);
    private String responseMode;
    private String logoutUrl;
    private int connectTimeout = 500;
    private int readTimeout = 5000;
    private boolean withState = true;
    private Map<String, String> mappedClaims = new LinkedHashMap<String, String>();
    private ValueGenerator stateGenerator = new RandomValueGenerator();
    private ValueGenerator codeVerifierGenerator = new RandomValueGenerator(50);
    private ValueRetriever valueRetriever = new SessionStoreValueRetriever();
    private boolean expireSessionWithToken = true;
    private int tokenExpirationAdvance = 0;
    private LogoutHandler logoutHandler;
    private TokenValidator tokenValidator;
    private boolean allowUnsignedIdTokens;

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"clientId", (String)this.getClientId());
        if (!(AUTHORIZATION_CODE_FLOWS.contains(this.responseType) || IMPLICIT_FLOWS.contains(this.responseType) || HYBRID_CODE_FLOWS.contains(this.responseType))) {
            throw new TechnicalException("Unsupported responseType: " + this.responseType);
        }
        if (!IMPLICIT_FLOWS.contains(this.responseType) && this.isDisablePkce()) {
            CommonHelper.assertNotBlank((String)"secret", (String)this.getSecret());
        }
        if (this.getDiscoveryURI() == null && this.getProviderMetadata() == null) {
            throw new TechnicalException("You must define either the discovery URL or directly the provider metadata");
        }
        if (this.getResourceRetriever() == null) {
            this.setResourceRetriever((ResourceRetriever)new DefaultResourceRetriever(this.getConnectTimeout(), this.getReadTimeout()));
        }
        if (this.getProviderMetadata() == null) {
            CommonHelper.assertNotBlank((String)"discoveryURI", (String)this.getDiscoveryURI());
            try {
                this.setProviderMetadata(OIDCProviderMetadata.parse((String)this.getResourceRetriever().retrieveResource(new URL(this.getDiscoveryURI())).getContent()));
            }
            catch (ParseException | IOException e) {
                throw new TechnicalException(e);
            }
        }
        if (this.logoutHandler == null) {
            this.logoutHandler = new DefaultLogoutHandler();
        }
    }

    public OIDCProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public OIDCProviderMetadata findProviderMetadata() {
        this.init();
        return this.providerMetadata;
    }

    public void setProviderMetadata(OIDCProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void defaultDiscoveryURI(String discoveryURI) {
        if (this.discoveryURI == null) {
            this.discoveryURI = discoveryURI;
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public String getCustomParam(String name) {
        return this.customParams.get(name);
    }

    public void setCustomParams(Map<String, String> customParams) {
        CommonHelper.assertNotNull((String)"customParams", customParams);
        this.customParams = customParams;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethodAsString(String auth) {
        this.clientAuthenticationMethod = ClientAuthenticationMethod.parse((String)auth);
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public boolean isDisablePkce() {
        return this.disablePkce;
    }

    public void setDisablePkce(boolean disablePkce) {
        this.disablePkce = disablePkce;
    }

    public CodeChallengeMethod findPkceMethod() {
        this.init();
        if (this.isDisablePkce()) {
            return null;
        }
        if (this.getPkceMethod() == null) {
            if (this.getProviderMetadata() == null) {
                return null;
            }
            List methods = this.getProviderMetadata().getCodeChallengeMethods();
            if (methods == null || methods.isEmpty()) {
                return null;
            }
            if (methods.contains(CodeChallengeMethod.S256)) {
                return CodeChallengeMethod.S256;
            }
            return (CodeChallengeMethod)methods.get(0);
        }
        return this.getPkceMethod();
    }

    public CodeChallengeMethod getPkceMethod() {
        return this.pkceMethod;
    }

    public void setPkceMethod(CodeChallengeMethod pkceMethod) {
        this.pkceMethod = pkceMethod;
    }

    public JWSAlgorithm getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    public void setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
    }

    public void setPreferredJwsAlgorithmAsString(String preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = JWSAlgorithm.parse((String)preferredJwsAlgorithm);
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void configureHttpRequest(HTTPRequest request) {
        request.setConnectTimeout(this.getConnectTimeout());
        request.setReadTimeout(this.getReadTimeout());
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public ResourceRetriever findResourceRetriever() {
        this.init();
        return this.resourceRetriever;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    public String getResponseType() {
        return this.responseType.toString();
    }

    public void setResponseType(String responseType) {
        try {
            this.responseType = ResponseType.parse((String)responseType);
        }
        catch (ParseException e) {
            throw new TechnicalException("Unrecognised responseType: " + responseType, (Throwable)e);
        }
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String findLogoutUrl() {
        this.init();
        if (this.logoutUrl == null && this.getProviderMetadata().getEndSessionEndpointURI() != null) {
            return this.getProviderMetadata().getEndSessionEndpointURI().toString();
        }
        return this.logoutUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    public boolean isExpireSessionWithToken() {
        return this.expireSessionWithToken;
    }

    public void setExpireSessionWithToken(boolean expireSessionWithToken) {
        this.expireSessionWithToken = expireSessionWithToken;
    }

    public int getTokenExpirationAdvance() {
        return this.isExpireSessionWithToken() ? this.tokenExpirationAdvance : -1;
    }

    public void setTokenExpirationAdvance(int tokenExpirationAdvance) {
        this.tokenExpirationAdvance = tokenExpirationAdvance;
    }

    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    public void setStateGenerator(ValueGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }

    public ValueGenerator getCodeVerifierGenerator() {
        return this.codeVerifierGenerator;
    }

    public void setCodeVerifierGenerator(ValueGenerator codeVerifierGenerator) {
        CommonHelper.assertNotNull((String)"codeVerifierGenerator", (Object)codeVerifierGenerator);
        this.codeVerifierGenerator = codeVerifierGenerator;
    }

    public ValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    public void setValueRetriever(ValueRetriever valueRetriever) {
        CommonHelper.assertNotNull((String)"valueRetriever", (Object)valueRetriever);
        this.valueRetriever = valueRetriever;
    }

    public LogoutHandler findLogoutHandler() {
        this.init();
        return this.logoutHandler;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public TokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public void setTokenValidator(TokenValidator tokenValidator) {
        this.tokenValidator = tokenValidator;
    }

    public TokenValidator findTokenValidator() {
        if (this.tokenValidator == null) {
            this.setTokenValidator(new TokenValidator(this));
        }
        return this.tokenValidator;
    }

    public Map<String, String> getMappedClaims() {
        return this.mappedClaims;
    }

    public void setMappedClaims(Map<String, String> mappedClaims) {
        this.mappedClaims = mappedClaims;
    }

    public boolean isAllowUnsignedIdTokens() {
        return this.allowUnsignedIdTokens;
    }

    public void setAllowUnsignedIdTokens(boolean allowUnsignedIdTokens) {
        this.allowUnsignedIdTokens = allowUnsignedIdTokens;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"clientId", this.clientId, "secret", "[protected]", "discoveryURI", this.discoveryURI, SCOPE, this.scope, "customParams", this.customParams, "clientAuthenticationMethod", this.clientAuthenticationMethod, "useNonce", this.useNonce, "preferredJwsAlgorithm", this.preferredJwsAlgorithm, "maxAge", this.maxAge, "maxClockSkew", this.maxClockSkew, "connectTimeout", this.connectTimeout, "readTimeout", this.readTimeout, "resourceRetriever", this.resourceRetriever, "responseType", this.responseType, "responseMode", this.responseMode, "logoutUrl", this.logoutUrl, "withState", this.withState, "stateGenerator", this.stateGenerator, "logoutHandler", this.logoutHandler, "tokenValidator", this.tokenValidator, "mappedClaims", this.mappedClaims, "allowUnsignedIdTokens", this.allowUnsignedIdTokens});
    }
}

