/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator
extends ProfileDefinitionAware
implements ProfileCreator {
    private static final Logger logger = LoggerFactory.getLogger(OidcProfileCreator.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcProfileCreator(OidcConfiguration configuration, OidcClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.defaultProfileDefinition((ProfileDefinition)new OidcProfileDefinition());
    }

    public Optional<UserProfile> create(Credentials cred, WebContext context, SessionStore sessionStore) {
        this.init();
        OidcCredentials credentials = (OidcCredentials)cred;
        AccessToken accessToken = credentials.getAccessToken();
        OidcProfile profile = (OidcProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setAccessToken(accessToken);
        JWT idToken = credentials.getIdToken();
        profile.setIdTokenString(idToken.getParsedString());
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null && !refreshToken.getValue().isEmpty()) {
            profile.setRefreshToken(refreshToken);
            logger.debug("Refresh Token successful retrieved");
        }
        try {
            Nonce nonce = this.configuration.isUseNonce() ? new Nonce((String)sessionStore.get(context, this.client.getNonceSessionAttributeName()).orElse(null)) : null;
            IDTokenClaimsSet claimsSet = this.configuration.findTokenValidator().validate(idToken, nonce);
            CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)claimsSet.getSubject()));
            if (this.configuration.findProviderMetadata().getUserInfoEndpointURI() != null && accessToken != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.findProviderMetadata().getUserInfoEndpointURI(), accessToken);
                HTTPRequest hTTPRequest = userInfoRequest.toHTTPRequest();
                this.configuration.configureHttpRequest(hTTPRequest);
                HTTPResponse httpResponse = hTTPRequest.send();
                logger.debug("User info response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
                    if (userInfoClaimsSet != null) {
                        this.getProfileDefinition().convertAndAdd((UserProfile)profile, userInfoClaimsSet.getClaims(), null);
                    } else {
                        logger.warn("Cannot retrieve claims from user info");
                    }
                }
            }
            for (Map.Entry entry : idToken.getJWTClaimsSet().getClaims().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
            }
            this.collectClaimsFromAccessTokenIfAny(credentials, nonce, profile);
            profile.setTokenExpirationAdvance(this.configuration.getTokenExpirationAdvance());
            String sid = (String)claimsSet.getClaim("sid");
            if (CommonHelper.isNotBlank((String)sid)) {
                this.configuration.findLogoutHandler().recordSession(context, sessionStore, sid);
            }
            return Optional.of(profile);
        }
        catch (JOSEException | BadJOSEException | ParseException | IOException | java.text.ParseException e) {
            throw new TechnicalException(e);
        }
    }

    private void collectClaimsFromAccessTokenIfAny(OidcCredentials credentials, Nonce nonce, OidcProfile profile) {
        try {
            JWT accessTokenJwt = JWTParser.parse((String)credentials.getAccessToken().getValue());
            IDTokenClaimsSet accessTokenClaims = this.configuration.findTokenValidator().validate(accessTokenJwt, nonce);
            for (Map.Entry entry : accessTokenClaims.toJWTClaimsSet().getClaims().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
            }
        }
        catch (JOSEException | BadJOSEException | ParseException | java.text.ParseException e) {
            logger.debug(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

