/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.config.OidcConfiguration;

public class AzureAd2OidcConfiguration
extends OidcConfiguration {
    private String tenant;

    public AzureAd2OidcConfiguration() {
    }

    public AzureAd2OidcConfiguration(OidcConfiguration oidcConfiguration) {
        this.setProviderMetadata(oidcConfiguration.getProviderMetadata());
        this.setClientId(oidcConfiguration.getClientId());
        this.setSecret(oidcConfiguration.getSecret());
        this.setScope(oidcConfiguration.getScope());
        this.setCustomParams(oidcConfiguration.getCustomParams());
        this.setClientAuthenticationMethod(oidcConfiguration.getClientAuthenticationMethod());
        this.setUseNonce(oidcConfiguration.isUseNonce());
        this.setPreferredJwsAlgorithm(oidcConfiguration.getPreferredJwsAlgorithm());
        this.setMaxClockSkew(oidcConfiguration.getMaxClockSkew());
        this.setConnectTimeout(oidcConfiguration.getConnectTimeout());
        this.setReadTimeout(oidcConfiguration.getReadTimeout());
        this.setDiscoveryURI(oidcConfiguration.getDiscoveryURI());
        this.setResourceRetriever(oidcConfiguration.getResourceRetriever());
        this.setResponseType(oidcConfiguration.getResponseType());
        this.setResponseMode(oidcConfiguration.getResponseMode());
        this.setLogoutUrl(oidcConfiguration.getLogoutUrl());
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        if (CommonHelper.isBlank((String)this.getTenant())) {
            this.setTenant("common");
        }
        super.internalInit(forceReinit);
    }

    @Override
    public String getDiscoveryURI() {
        return "https://login.microsoftonline.com/" + this.getTenant() + "/v2.0/.well-known/openid-configuration";
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String makeOauth2TokenRequest(String refreshToken) {
        String scope = this.getScope();
        if (CommonHelper.isBlank((String)scope)) {
            scope = "openid profile email";
        }
        String payload = HttpUtils.encodeQueryParam((String)"client_id", (String)this.getClientId()) + "&" + HttpUtils.encodeQueryParam((String)"client_secret", (String)this.getSecret()) + "&" + HttpUtils.encodeQueryParam((String)"grant_type", (String)"refresh_token") + "&" + HttpUtils.encodeQueryParam((String)"refresh_token", (String)refreshToken) + "&" + HttpUtils.encodeQueryParam((String)"tenant", (String)this.getTenant()) + "&" + HttpUtils.encodeQueryParam((String)"scope", (String)scope);
        return payload;
    }
}

