/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.redirect;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRedirectionActionBuilder
implements RedirectionActionBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRedirectionActionBuilder.class);
    protected OidcClient client;

    public OidcRedirectionActionBuilder(OidcClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(WebContext context, SessionStore sessionStore) {
        OidcConfigurationContext configContext = new OidcConfigurationContext(context, this.client.getConfiguration());
        Map<String, String> params = this.buildParams(context);
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
        params.put("redirect_uri", computedCallbackUrl);
        this.addStateAndNonceParameters(context, sessionStore, params);
        Integer maxAge = configContext.getMaxAge();
        if (maxAge != null) {
            params.put("max_age", maxAge.toString());
        }
        if (configContext.isForceAuthn().booleanValue()) {
            params.put("prompt", "login");
            params.put("max_age", "0");
        }
        if (configContext.isPassive().booleanValue()) {
            params.put("prompt", "none");
        }
        String location = this.buildAuthenticationRequestUrl(params);
        LOGGER.debug("Authentication request url: {}", (Object)location);
        return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)location));
    }

    protected Map<String, String> buildParams(WebContext webContext) {
        OidcConfigurationContext configContext = new OidcConfigurationContext(webContext, this.client.getConfiguration());
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("scope", configContext.getScope());
        authParams.put("response_type", configContext.getResponseType());
        authParams.put("response_mode", configContext.getResponseMode());
        authParams.putAll(configContext.getCustomParams());
        authParams.put("client_id", configContext.getConfiguration().getClientId());
        return new HashMap<String, String>(authParams);
    }

    protected void addStateAndNonceParameters(WebContext context, SessionStore sessionStore, Map<String, String> params) {
        CodeChallengeMethod pkceMethod;
        if (this.client.getConfiguration().isWithState()) {
            State state = new State(this.client.getConfiguration().getStateGenerator().generateValue(context, sessionStore));
            params.put("state", state.getValue());
            sessionStore.set(context, this.client.getStateSessionAttributeName(), (Object)state);
        }
        if (this.client.getConfiguration().isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            sessionStore.set(context, this.client.getNonceSessionAttributeName(), (Object)nonce.getValue());
        }
        if ((pkceMethod = this.client.getConfiguration().findPkceMethod()) != null) {
            CodeVerifier verfifier = new CodeVerifier(this.client.getConfiguration().getCodeVerifierGenerator().generateValue(context, sessionStore));
            sessionStore.set(context, this.client.getCodeVerifierSessionAttributeName(), (Object)verfifier);
            params.put("code_challenge", CodeChallenge.compute((CodeChallengeMethod)pkceMethod, (CodeVerifier)verfifier).getValue());
            params.put("code_challenge_method", pkceMethod.getValue());
        }
    }

    protected String buildAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            queryString = AuthenticationRequest.parse(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList((String)e.getValue())))).toQueryString();
        }
        catch (Exception e2) {
            throw new TechnicalException((Throwable)e2);
        }
        return this.client.getConfiguration().getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
    }
}

