/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator
extends ProfileDefinitionAware
implements ProfileCreator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileCreator.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcProfileCreator(OidcConfiguration configuration, OidcClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new OidcProfileDefinition());
    }

    public Optional<UserProfile> create(CallContext ctx, Credentials credentials) {
        this.init();
        OidcCredentials oidcCredentials = null;
        AccessToken accessToken = null;
        boolean regularOidcFlow = credentials instanceof OidcCredentials;
        if (regularOidcFlow) {
            oidcCredentials = (OidcCredentials)credentials;
            accessToken = oidcCredentials.getAccessToken();
        } else {
            String token = ((TokenCredentials)credentials).getToken();
            accessToken = new BearerAccessToken(token);
        }
        OidcProfile profile = (OidcProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setAccessToken(accessToken);
        if (oidcCredentials != null) {
            profile.setIdTokenString(oidcCredentials.getIdToken().getParsedString());
            RefreshToken refreshToken = oidcCredentials.getRefreshToken();
            if (refreshToken != null && !refreshToken.getValue().isEmpty()) {
                profile.setRefreshToken(refreshToken);
                LOGGER.debug("Refresh Token successful retrieved");
            }
        }
        try {
            OIDCProviderMetadata opMetadata;
            Nonce nonce = this.configuration.isUseNonce() ? new Nonce((String)ctx.sessionStore().get(ctx.webContext(), this.client.getNonceSessionAttributeName()).orElse(null)) : null;
            if (oidcCredentials != null) {
                IDTokenClaimsSet claimsSet = this.configuration.getOpMetadataResolver().getTokenValidator().validate(oidcCredentials.getIdToken(), nonce);
                CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
                profile.setId(ProfileHelper.sanitizeIdentifier((Object)claimsSet.getSubject()));
                String sid = (String)claimsSet.getClaim("sid");
                if (CommonHelper.isNotBlank((String)sid)) {
                    this.configuration.findSessionLogoutHandler().recordSession(ctx, sid);
                }
            }
            if ((opMetadata = (OIDCProviderMetadata)this.configuration.getOpMetadataResolver().load()).getUserInfoEndpointURI() != null && accessToken != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(opMetadata.getUserInfoEndpointURI(), accessToken);
                HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
                this.configuration.configureHttpRequest(userInfoHttpRequest);
                HTTPResponse httpResponse = userInfoHttpRequest.send();
                LOGGER.debug("User info response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    LOGGER.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                    if (!regularOidcFlow) {
                        return Optional.empty();
                    }
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
                    if (userInfoClaimsSet != null) {
                        this.getProfileDefinition().convertAndAdd((UserProfile)profile, userInfoClaimsSet.getClaims(), null);
                    } else {
                        LOGGER.warn("Cannot retrieve claims from user info");
                    }
                }
            }
            if (oidcCredentials != null) {
                for (Map.Entry entry : oidcCredentials.getIdToken().getJWTClaimsSet().getClaims().entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                    this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
                }
            }
            if (this.configuration.isIncludeAccessTokenClaimsInProfile()) {
                this.collectClaimsFromAccessTokenIfAny(oidcCredentials, nonce, (UserProfile)profile);
            }
            profile.setTokenExpirationAdvance(this.configuration.getTokenExpirationAdvance());
            return Optional.of(profile);
        }
        catch (JOSEException | BadJOSEException | ParseException | IOException | java.text.ParseException e) {
            throw new OidcException(e);
        }
    }

    private void collectClaimsFromAccessTokenIfAny(OidcCredentials credentials, Nonce nonce, UserProfile profile) {
        try {
            AccessToken accessToken = credentials.getAccessToken();
            if (accessToken != null) {
                JWT accessTokenJwt = JWTParser.parse((String)accessToken.getValue());
                IDTokenClaimsSet accessTokenClaims = this.configuration.getOpMetadataResolver().getTokenValidator().validate(accessTokenJwt, nonce);
                for (Map.Entry entry : accessTokenClaims.toJWTClaimsSet().getClaims().entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                    this.getProfileDefinition().convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
                }
            }
        }
        catch (JOSEException | BadJOSEException | ParseException | java.text.ParseException e) {
            LOGGER.debug(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new OidcException(e);
        }
    }
}

