/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.security.interfaces.ECPrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.metadata.StaticOidcOpMetadataResolver;

public class AppleOidcConfiguration
extends OidcConfiguration {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(15777000L);
    private ECPrivateKey privateKey;
    private String privateKeyID;
    private String teamID;
    private Store<String, String> store;
    private Duration timeout = MAX_TIMEOUT;

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"privateKeyID", (String)this.privateKeyID);
        CommonHelper.assertNotNull((String)"privateKey", (Object)this.privateKey);
        CommonHelper.assertNotBlank((String)"teamID", (String)this.teamID);
        if (this.timeout.compareTo(MAX_TIMEOUT) > 0) {
            throw new IllegalArgumentException(String.format("timeout must not be greater then %d seconds", MAX_TIMEOUT.toSeconds()));
        }
        if (this.store == null) {
            this.store = new GuavaStore(1000, (int)this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        OIDCProviderMetadata providerMetadata = new OIDCProviderMetadata(new Issuer("https://appleid.apple.com"), Collections.singletonList(SubjectType.PAIRWISE), URI.create("https://appleid.apple.com/auth/keys"));
        providerMetadata.setAuthorizationEndpointURI(URI.create("https://appleid.apple.com/auth/authorize"));
        providerMetadata.setTokenEndpointURI(URI.create("https://appleid.apple.com/auth/token"));
        providerMetadata.setIDTokenJWSAlgs(Collections.singletonList(JWSAlgorithm.RS256));
        this.opMetadataResolver = new StaticOidcOpMetadataResolver(this, providerMetadata);
        this.setClientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        super.internalInit(forceReinit);
    }

    @Override
    public String getSecret() {
        Optional cache;
        if (this.store != null && (cache = this.store.get((Object)this.getClientId())).isPresent()) {
            return (String)cache.get();
        }
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().issuer(this.getTeamID()).audience("https://appleid.apple.com").subject(this.getClientId()).issueTime(Date.from(Instant.now())).expirationTime(Date.from(Instant.now().plusSeconds(this.timeout.toSeconds()))).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(this.privateKeyID).build(), claimsSet);
        try {
            ECDSASigner signer = new ECDSASigner(this.privateKey);
            signedJWT.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            throw new OidcException(e);
        }
        String secret = signedJWT.serialize();
        if (this.store != null) {
            this.store.set((Object)this.getClientId(), (Object)secret);
        }
        return secret;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AppleOidcConfiguration(super=" + super.toString() + ", privateKeyID=" + this.privateKeyID + ", teamID=" + this.teamID + ", store=" + String.valueOf(this.store) + ", timeout=" + String.valueOf(this.timeout) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrivateKeyID() {
        return this.privateKeyID;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTeamID() {
        return this.teamID;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Store<String, String> getStore() {
        return this.store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration setPrivateKey(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration setPrivateKeyID(String privateKeyID) {
        this.privateKeyID = privateKeyID;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration setTeamID(String teamID) {
        this.teamID = teamID;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration setStore(Store<String, String> store) {
        this.store = store;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration withPrivateKey(ECPrivateKey privateKey) {
        return this.privateKey == privateKey ? this : new AppleOidcConfiguration(privateKey, this.privateKeyID, this.teamID, this.store, this.timeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration withPrivateKeyID(String privateKeyID) {
        return this.privateKeyID == privateKeyID ? this : new AppleOidcConfiguration(this.privateKey, privateKeyID, this.teamID, this.store, this.timeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration withTeamID(String teamID) {
        return this.teamID == teamID ? this : new AppleOidcConfiguration(this.privateKey, this.privateKeyID, teamID, this.store, this.timeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration withStore(Store<String, String> store) {
        return this.store == store ? this : new AppleOidcConfiguration(this.privateKey, this.privateKeyID, this.teamID, store, this.timeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration withTimeout(Duration timeout) {
        return this.timeout == timeout ? this : new AppleOidcConfiguration(this.privateKey, this.privateKeyID, this.teamID, this.store, timeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration(ECPrivateKey privateKey, String privateKeyID, String teamID, Store<String, String> store, Duration timeout) {
        this.privateKey = privateKey;
        this.privateKeyID = privateKeyID;
        this.teamID = teamID;
        this.store = store;
        this.timeout = timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AppleOidcConfiguration() {
    }
}

