/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import lombok.Generated;
import net.minidev.json.JSONObject;
import org.pac4j.core.credentials.Credentials;

public class OidcCredentials
extends Credentials {
    private static final long serialVersionUID = 6772331801527223938L;
    private String code;
    private Map<String, ?> accessToken;
    private Map<String, ?> refreshToken;
    private String idToken;

    @JsonIgnore
    public AuthorizationCode toAuthorizationCode() {
        return this.code != null ? new AuthorizationCode(this.code) : null;
    }

    @JsonIgnore
    public AccessToken toAccessToken() {
        try {
            return this.accessToken != null ? AccessToken.parse((JSONObject)new JSONObject(this.accessToken)) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @JsonIgnore
    public RefreshToken toRefreshToken() {
        try {
            return this.refreshToken != null ? RefreshToken.parse((JSONObject)new JSONObject(this.refreshToken)) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @JsonIgnore
    public JWT toIdToken() {
        try {
            return this.idToken != null ? JWTParser.parse((String)this.idToken) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @JsonIgnore
    public void setAccessTokenObject(AccessToken accessToken) {
        this.setAccessToken((Map<String, ?>)accessToken.toJSONObject());
    }

    @JsonIgnore
    public void setRefreshTokenObject(RefreshToken refreshToken) {
        this.setRefreshToken((Map<String, ?>)refreshToken.toJSONObject());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCode() {
        return this.code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, ?> getAccessToken() {
        return this.accessToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, ?> getRefreshToken() {
        return this.refreshToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getIdToken() {
        return this.idToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAccessToken(Map<String, ?> accessToken) {
        this.accessToken = accessToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRefreshToken(Map<String, ?> refreshToken) {
        this.refreshToken = refreshToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OidcCredentials(code=" + this.code + ", accessToken=" + String.valueOf(this.accessToken) + ", refreshToken=" + String.valueOf(this.refreshToken) + ", idToken=" + this.idToken + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcCredentials)) {
            return false;
        }
        OidcCredentials other = (OidcCredentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.code;
        String other$code = other.code;
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OidcCredentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.code;
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }
}

