/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.context;

import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.context.ExtendedSAMLMessageContext;
import org.pac4j.saml.exceptions.SamlException;
import org.pac4j.saml.transport.SimpleRequestAdapter;
import org.pac4j.saml.transport.SimpleResponseAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Saml2ContextProvider {
    protected static final Logger logger = LoggerFactory.getLogger(Saml2ContextProvider.class);
    protected MetadataProvider metadata;
    protected String idpEntityId;
    protected String spEntityId;

    public Saml2ContextProvider(MetadataProvider metadata, String idpEntityId, String spEntityId) {
        this.metadata = metadata;
        this.idpEntityId = idpEntityId;
        this.spEntityId = spEntityId;
    }

    public ExtendedSAMLMessageContext buildSpContext(WebContext webContext) {
        ExtendedSAMLMessageContext context = new ExtendedSAMLMessageContext();
        context.setMetadataProvider(this.metadata);
        this.addTransportContext(webContext, context);
        this.addSPContext(context);
        return context;
    }

    public ExtendedSAMLMessageContext buildSpAndIdpContext(WebContext webContext) {
        ExtendedSAMLMessageContext context = new ExtendedSAMLMessageContext();
        context.setMetadataProvider(this.metadata);
        this.addTransportContext(webContext, context);
        this.addSPContext(context);
        this.addIDPContext(context);
        return context;
    }

    protected void addTransportContext(WebContext webContext, BasicSAMLMessageContext context) {
        SimpleRequestAdapter inTransport = new SimpleRequestAdapter(webContext);
        SimpleResponseAdapter outTransport = new SimpleResponseAdapter();
        context.setInboundMessageTransport((InTransport)inTransport);
        context.setOutboundMessageTransport((OutTransport)outTransport);
    }

    protected void addSPContext(BasicSAMLMessageContext context) {
        context.setLocalEntityId(this.spEntityId);
        context.setLocalEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor entityDescriptor = null;
        RoleDescriptor roleDescriptor = null;
        try {
            entityDescriptor = this.metadata.getEntityDescriptor(this.spEntityId);
            roleDescriptor = this.metadata.getRole(this.spEntityId, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
        }
        catch (MetadataProviderException e) {
            throw new SamlException("An error occured while getting SP descriptors", e);
        }
        if (entityDescriptor == null || roleDescriptor == null) {
            throw new SamlException("Cannot find entity " + this.spEntityId + " or role " + SPSSODescriptor.DEFAULT_ELEMENT_NAME + " in metadata provider");
        }
        context.setLocalEntityMetadata(entityDescriptor);
        context.setLocalEntityRoleMetadata(roleDescriptor);
    }

    protected void addIDPContext(BasicSAMLMessageContext context) {
        context.setPeerEntityId(this.idpEntityId);
        context.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor entityDescriptor = null;
        RoleDescriptor roleDescriptor = null;
        try {
            entityDescriptor = this.metadata.getEntityDescriptor(this.idpEntityId);
            roleDescriptor = this.metadata.getRole(this.idpEntityId, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
        }
        catch (MetadataProviderException e) {
            throw new SamlException("An error occured while getting IDP descriptors", e);
        }
        if (entityDescriptor == null || roleDescriptor == null) {
            throw new SamlException("Cannot find entity " + this.idpEntityId + " or role " + IDPSSODescriptor.DEFAULT_ELEMENT_NAME + " in metadata provider");
        }
        context.setPeerEntityMetadata(entityDescriptor);
        context.setPeerEntityRoleMetadata(roleDescriptor);
    }
}

