/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso;

import java.util.Random;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.pac4j.saml.util.SamlUtils;

public class Saml2AuthnRequestBuilder {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public AuthnRequest build(SAMLMessageContext context) {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
        SingleSignOnService ssoService = SamlUtils.getSingleSignOnService(idpssoDescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        AssertionConsumerService assertionConsumerService = SamlUtils.getAssertionConsumerService(spDescriptor, null);
        return this.buildAuthnRequest(context, assertionConsumerService, ssoService);
    }

    protected AuthnRequest buildAuthnRequest(SAMLMessageContext context, AssertionConsumerService assertionConsumerService, SingleSignOnService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        request.setID(this.generateID());
        request.setIssuer(this.getIssuer(context.getLocalEntityId()));
        request.setIssueInstant(new DateTime());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIsPassive(Boolean.valueOf(false));
        request.setForceAuthn(Boolean.valueOf(false));
        request.setProviderName("pac4j-saml");
        request.setDestination(ssoService.getLocation());
        request.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        request.setProtocolBinding(assertionConsumerService.getBinding());
        return request;
    }

    protected Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    protected String generateID() {
        Random r = new Random();
        return '_' + Long.toString(Math.abs(r.nextLong()), 16) + Long.toString(Math.abs(r.nextLong()), 16);
    }
}

