/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso;

import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;
import org.pac4j.saml.context.ExtendedSAMLMessageContext;
import org.pac4j.saml.exceptions.SamlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Saml2ResponseValidator {
    private static final Logger logger = LoggerFactory.getLogger(Saml2ResponseValidator.class);
    private int acceptedSkew = 120;
    private int maximumAuthenticationLifetime = 3600;

    public void validateSamlResponse(ExtendedSAMLMessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        SAMLObject message = context.getInboundSAMLMessage();
        if (!(message instanceof Response)) {
            throw new SamlException("Response instance is an unsupported type");
        }
        Response response = (Response)message;
        this.validateSamlProtocolResponse(response, context, engine);
        this.decryptEncryptedAssertions(response, decrypter);
        this.validateSamlSSOResponse(response, context, engine, decrypter);
    }

    public void validateSamlProtocolResponse(Response response, ExtendedSAMLMessageContext context, SignatureTrustEngine engine) {
        if (!this.isIssueInstantValid(response.getIssueInstant())) {
            throw new SamlException("Response issue instant is too old or in the future");
        }
        if (response.getIssuer() != null) {
            this.validateIssuer(response.getIssuer(), context);
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            String status = response.getStatus().getStatusCode().getValue();
            if (response.getStatus().getStatusMessage() != null) {
                status = status + " / " + response.getStatus().getStatusMessage().getMessage();
            }
            throw new SamlException("Authentication response is not success ; actual " + status);
        }
        if (response.getSignature() != null) {
            this.validateSignature(response.getSignature(), context.getPeerEntityId(), engine);
            context.setInboundSAMLMessageAuthenticated(true);
        }
    }

    public void validateSamlSSOResponse(Response response, ExtendedSAMLMessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getAuthnStatements().size() <= 0) continue;
            try {
                this.validateAssertion(assertion, context, engine, decrypter);
            }
            catch (SamlException e) {
                logger.error("Current assertion validation failed, continue with the next one", (Throwable)((Object)e));
                continue;
            }
            context.setSubjectAssertion(assertion);
            break;
        }
        if (context.getSubjectAssertion() == null) {
            throw new SamlException("No valid subject assertion found in response");
        }
        if (context.getSubjectNameIdentifier() == null) {
            throw new SamlException("Subject NameID cannot be null");
        }
    }

    protected void decryptEncryptedAssertions(Response response, Decrypter decrypter) {
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(decryptedAssertion);
            }
            catch (DecryptionException e) {
                logger.error("Decryption of assertion failed, continue with the next one", (Throwable)e);
            }
        }
    }

    protected void validateIssuer(Issuer issuer, ExtendedSAMLMessageContext context) {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SamlException("Issuer type is not entity but " + issuer.getFormat());
        }
        if (!context.getPeerEntityMetadata().getEntityID().equals(issuer.getValue())) {
            throw new SamlException("Issuer " + issuer.getValue() + " does not match idp entityId " + context.getPeerEntityMetadata().getEntityID());
        }
    }

    protected void validateAssertion(Assertion assertion, ExtendedSAMLMessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        if (!this.isIssueInstantValid(assertion.getIssueInstant())) {
            throw new SamlException("Assertion issue instant is too old or in the future");
        }
        this.validateIssuer(assertion.getIssuer(), context);
        if (assertion.getSubject() == null) {
            throw new SamlException("Assertion subject cannot be null");
        }
        this.validateSubject(assertion.getSubject(), context, decrypter);
        this.validateAssertionConditions(assertion.getConditions(), context);
        this.validateAuthenticationStatements(assertion.getAuthnStatements(), context);
        this.validateAssertionSignature(assertion.getSignature(), context, engine);
    }

    protected void validateSubject(Subject subject, ExtendedSAMLMessageContext context, Decrypter decrypter) {
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod()) || !this.isValidBearerSubjectConfirmationData(confirmation.getSubjectConfirmationData(), context)) continue;
            NameID nameID = null;
            if (subject.getEncryptedID() != null) {
                try {
                    nameID = (NameID)decrypter.decrypt(subject.getEncryptedID());
                }
                catch (DecryptionException e) {
                    throw new SamlException("Decryption of nameID's subject failed", e);
                }
            } else {
                nameID = subject.getNameID();
            }
            context.setSubjectNameIdentifier((SAMLObject)nameID);
            return;
        }
        throw new SamlException("Subject confirmation validation failed");
    }

    protected boolean isValidBearerSubjectConfirmationData(SubjectConfirmationData data, ExtendedSAMLMessageContext context) {
        if (data == null) {
            logger.debug("SubjectConfirmationData cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotBefore() != null) {
            logger.debug("SubjectConfirmationData notBefore must be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter() == null) {
            logger.debug("SubjectConfirmationData notOnOrAfter cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            logger.debug("SubjectConfirmationData notOnOrAfter is too old");
            return false;
        }
        if (data.getRecipient() == null) {
            logger.debug("SubjectConfirmationData recipient cannot be null for Bearer confirmation");
            return false;
        }
        if (!data.getRecipient().equals(context.getAssertionConsumerUrl())) {
            logger.debug("SubjectConfirmationData recipient {} does not match SP assertion consumer URL, found", (Object)data.getRecipient());
            return false;
        }
        return true;
    }

    protected void validateAssertionConditions(Conditions conditions, ExtendedSAMLMessageContext context) {
        if (conditions == null) {
            throw new SamlException("Assertion conditions cannot be null");
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minusSeconds(this.acceptedSkew).isAfterNow()) {
            throw new SamlException("Assertion condition notBefore is not valid");
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            throw new SamlException("Assertion condition notOnOrAfter is not valid");
        }
        this.validateAudienceRestrictions(conditions.getAudienceRestrictions(), context.getLocalEntityId());
    }

    protected void validateAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        if (audienceRestrictions == null || audienceRestrictions.size() == 0) {
            throw new SamlException("Audience restrictions cannot be null or empty");
        }
        if (!this.matchAudienceRestriction(audienceRestrictions, spEntityId)) {
            throw new SamlException("Assertion audience does not match SP configuration");
        }
    }

    protected void validateAuthenticationStatements(List<AuthnStatement> authnStatements, ExtendedSAMLMessageContext context) {
        for (AuthnStatement statement : authnStatements) {
            if (!this.isAuthnInstantValid(statement.getAuthnInstant())) {
                throw new SamlException("Authentication issue instant is too old or in the future");
            }
            if (statement.getSessionNotOnOrAfter() == null || !statement.getSessionNotOnOrAfter().isBeforeNow()) continue;
            throw new SamlException("Authentication session between IDP and subject has ended");
        }
    }

    protected void validateAssertionSignature(Signature signature, ExtendedSAMLMessageContext context, SignatureTrustEngine engine) {
        if (signature != null) {
            this.validateSignature(signature, context.getPeerEntityMetadata().getEntityID(), engine);
        } else if (((SPSSODescriptor)context.getLocalEntityRoleMetadata()).getWantAssertionsSigned().booleanValue() && !context.isInboundSAMLMessageAuthenticated()) {
            throw new SamlException("Assertion or response must be signed");
        }
    }

    protected void validateSignature(Signature signature, String idpEntityId, SignatureTrustEngine trustEngine) {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (ValidationException e) {
            throw new SamlException("SAMLSignatureProfileValidator failed to validate signature", e);
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        criteriaSet.add((Object)new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new EntityIDCriteria(idpEntityId));
        boolean valid = false;
        try {
            valid = trustEngine.validate((Object)signature, criteriaSet);
        }
        catch (SecurityException e) {
            throw new SamlException("An error occured during signature validation", e);
        }
        if (!valid) {
            throw new SamlException("Signature is not trusted");
        }
    }

    private boolean matchAudienceRestriction(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() == null) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                if (!spEntityId.equals(audience.getAudienceURI())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDateValid(DateTime issueInstant, int interval) {
        long now = System.currentTimeMillis();
        return issueInstant.isBefore(now + (long)(this.acceptedSkew * 1000)) && issueInstant.isAfter(now - (long)((this.acceptedSkew + interval) * 1000));
    }

    private boolean isIssueInstantValid(DateTime issueInstant) {
        return this.isDateValid(issueInstant, 0);
    }

    private boolean isAuthnInstantValid(DateTime authnInstant) {
        return this.isDateValid(authnInstant, this.maximumAuthenticationLifetime);
    }

    public void setAcceptedSkew(int acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    public void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }
}

