/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.ChainingMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Protocol;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.context.ExtendedSAMLMessageContext;
import org.pac4j.saml.context.Saml2ContextProvider;
import org.pac4j.saml.credentials.Saml2Credentials;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.EncryptionProvider;
import org.pac4j.saml.crypto.SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SamlException;
import org.pac4j.saml.metadata.Saml2MetadataGenerator;
import org.pac4j.saml.profile.Saml2Profile;
import org.pac4j.saml.sso.Saml2AuthnRequestBuilder;
import org.pac4j.saml.sso.Saml2ResponseValidator;
import org.pac4j.saml.sso.Saml2WebSSOProfileHandler;
import org.pac4j.saml.transport.Pac4jHTTPPostDecoder;
import org.pac4j.saml.transport.SimpleResponseAdapter;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Saml2Client
extends BaseClient<Saml2Credentials, Saml2Profile> {
    protected static final Logger logger = LoggerFactory.getLogger(Saml2Client.class);
    public static final String SAML_METADATA_KEY_INFO_GENERATOR = "MetadataKeyInfoGenerator";
    private String keystorePath;
    private String keystorePassword;
    private String privateKeyPassword;
    private String idpMetadataPath;
    private String idpEntityId;
    private Integer maximumAuthenticationLifetime;
    private CredentialProvider credentialProvider;
    private Saml2ContextProvider contextProvider;
    private Saml2AuthnRequestBuilder authnRequestBuilder;
    private Saml2WebSSOProfileHandler handler;
    private Saml2ResponseValidator responseValidator;
    private SignatureTrustEngineProvider signatureTrustEngineProvider;
    private EncryptionProvider encryptionProvider;
    private String spMetadata;

    protected void internalInit() {
        FilesystemMetadataProvider idpMetadataProvider;
        CommonHelper.assertNotBlank((String)"keystorePath", (String)this.keystorePath);
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.keystorePassword);
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.privateKeyPassword);
        CommonHelper.assertNotBlank((String)"idpMetadataPath", (String)this.idpMetadataPath);
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        if (!this.callbackUrl.startsWith("http")) {
            throw new TechnicalException("SAML callbackUrl must be absolute");
        }
        try {
            DefaultBootstrap.bootstrap();
            NamedKeyInfoGeneratorManager manager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager();
            X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
            generator.setEmitEntityCertificate(true);
            generator.setEmitEntityCertificateChain(true);
            manager.registerFactory(SAML_METADATA_KEY_INFO_GENERATOR, (KeyInfoGeneratorFactory)generator);
        }
        catch (ConfigurationException e) {
            throw new SamlException("Error bootstrapping OpenSAML", e);
        }
        this.credentialProvider = new CredentialProvider(this.keystorePath, this.keystorePassword, this.privateKeyPassword);
        StaticBasicParserPool parserPool = new StaticBasicParserPool();
        try {
            parserPool.initialize();
        }
        catch (XMLParserException e) {
            throw new SamlException("Error initializing parserPool", e);
        }
        try {
            URL url = CommonHelper.getURLFromName((String)this.idpMetadataPath);
            idpMetadataProvider = new FilesystemMetadataProvider(new File(url.toURI()));
            idpMetadataProvider.setParserPool((ParserPool)parserPool);
            idpMetadataProvider.initialize();
        }
        catch (MetadataProviderException e) {
            throw new SamlException("Error initializing idpMetadataProvider", e);
        }
        catch (URISyntaxException e) {
            throw new TechnicalException("Error converting idp Metadata path url to uri", (Throwable)e);
        }
        if (this.idpEntityId == null) {
            try {
                XMLObject md = idpMetadataProvider.getMetadata();
                if (md instanceof EntitiesDescriptor) {
                    Iterator i$ = ((EntitiesDescriptor)md).getEntityDescriptors().iterator();
                    if (i$.hasNext()) {
                        EntityDescriptor entity = (EntityDescriptor)i$.next();
                        this.idpEntityId = entity.getEntityID();
                    }
                } else if (md instanceof EntityDescriptor) {
                    this.idpEntityId = ((EntityDescriptor)md).getEntityID();
                }
            }
            catch (MetadataProviderException e) {
                throw new SamlException("Error getting idp entityId from IDP metadata", e);
            }
            if (this.idpEntityId == null) {
                throw new SamlException("No idp entityId found");
            }
        }
        Saml2MetadataGenerator metadataGenerator = new Saml2MetadataGenerator();
        metadataGenerator.setCredentialProvider(this.credentialProvider);
        String spEntityId = this.getCallbackUrl();
        metadataGenerator.setEntityId(spEntityId);
        metadataGenerator.setAssertionConsumerServiceUrl(this.getCallbackUrl());
        metadataGenerator.setSingleLogoutServiceUrl(this.getCallbackUrl());
        AbstractMetadataProvider spMetadataProvider = metadataGenerator.buildMetadataProvider();
        try {
            spMetadataProvider.initialize();
            this.spMetadata = metadataGenerator.printMetadata();
        }
        catch (MetadataProviderException e) {
            throw new TechnicalException("Error initializing spMetadataProvider", (Throwable)e);
        }
        catch (MarshallingException e) {
            logger.warn("Unable to print SP metadata", (Throwable)e);
        }
        ChainingMetadataProvider metadataManager = new ChainingMetadataProvider();
        try {
            metadataManager.addMetadataProvider((MetadataProvider)idpMetadataProvider);
            metadataManager.addMetadataProvider((MetadataProvider)spMetadataProvider);
        }
        catch (MetadataProviderException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        this.contextProvider = new Saml2ContextProvider((MetadataProvider)metadataManager, this.idpEntityId, spEntityId);
        VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
        this.authnRequestBuilder = new Saml2AuthnRequestBuilder();
        HTTPPostEncoder postEncoder = new HTTPPostEncoder(velocityEngine, "/templates/saml2-post-binding.vm");
        Pac4jHTTPPostDecoder postDecoder = new Pac4jHTTPPostDecoder(parserPool);
        this.handler = new Saml2WebSSOProfileHandler(this.credentialProvider, (MessageEncoder)postEncoder, (MessageDecoder)postDecoder, parserPool);
        this.signatureTrustEngineProvider = new SignatureTrustEngineProvider((MetadataProvider)metadataManager);
        this.encryptionProvider = new EncryptionProvider(this.credentialProvider);
        this.responseValidator = new Saml2ResponseValidator();
        if (this.maximumAuthenticationLifetime != null) {
            this.responseValidator.setMaximumAuthenticationLifetime(this.maximumAuthenticationLifetime);
        }
    }

    protected BaseClient<Saml2Credentials, Saml2Profile> newClient() {
        Saml2Client client = new Saml2Client();
        client.setKeystorePath(this.keystorePath);
        client.setKeystorePassword(this.keystorePassword);
        client.setPrivateKeyPassword(this.privateKeyPassword);
        client.setIdpMetadataPath(this.idpMetadataPath);
        client.setIdpEntityId(this.idpEntityId);
        client.setMaximumAuthenticationLifetime(this.maximumAuthenticationLifetime);
        client.setCallbackUrl(this.callbackUrl);
        return client;
    }

    protected boolean isDirectRedirection() {
        return false;
    }

    protected RedirectAction retrieveRedirectAction(WebContext wc) {
        ExtendedSAMLMessageContext context = this.contextProvider.buildSpAndIdpContext(wc);
        String relayState = this.getContextualCallbackUrl(wc);
        AuthnRequest authnRequest = this.authnRequestBuilder.build((SAMLMessageContext)context);
        this.handler.sendMessage((SAMLMessageContext)context, authnRequest, relayState);
        String content = ((SimpleResponseAdapter)context.getOutboundMessageTransport()).getOutgoingContent();
        return RedirectAction.success((String)content);
    }

    protected Saml2Credentials retrieveCredentials(WebContext wc) throws RequiresHttpAction {
        ExtendedSAMLMessageContext context = this.contextProvider.buildSpContext(wc);
        context.setAssertionConsumerUrl(this.getCallbackUrl());
        SignatureTrustEngine trustEngine = this.signatureTrustEngineProvider.build();
        Decrypter decrypter = this.encryptionProvider.buildDecrypter();
        this.handler.receiveMessage((SAMLMessageContext)context, trustEngine);
        this.responseValidator.validateSamlResponse(context, trustEngine, decrypter);
        return this.buildSaml2Credentials(context, decrypter);
    }

    private Saml2Credentials buildSaml2Credentials(ExtendedSAMLMessageContext context, Decrypter decrypter) {
        NameID nameId = (NameID)context.getSubjectNameIdentifier();
        Assertion subjectAssertion = context.getSubjectAssertion();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attributeStatement : subjectAssertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                attributes.add(attribute);
            }
            for (EncryptedAttribute encryptedAttribute : attributeStatement.getEncryptedAttributes()) {
                try {
                    attributes.add(decrypter.decrypt(encryptedAttribute));
                }
                catch (DecryptionException e) {
                    logger.warn("Decryption of attribute failed, continue with the next one", (Throwable)e);
                }
            }
        }
        return new Saml2Credentials(nameId, attributes, this.getName());
    }

    protected Saml2Profile retrieveUserProfile(Saml2Credentials credentials, WebContext context) {
        Saml2Profile profile = new Saml2Profile();
        profile.setId(credentials.getNameId().getValue());
        for (Attribute attribute : credentials.getAttributes()) {
            ArrayList<String> values = new ArrayList<String>();
            for (XMLObject attributeValue : attribute.getAttributeValues()) {
                Element attributeValueElement = attributeValue.getDOM();
                String value = attributeValueElement.getTextContent();
                values.add(value);
            }
            profile.addAttribute(attribute.getName(), values);
        }
        return profile;
    }

    public Protocol getProtocol() {
        return Protocol.SAML;
    }

    public void setIdpMetadataPath(String idpMetadataPath) {
        this.idpMetadataPath = idpMetadataPath;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public void setMaximumAuthenticationLifetime(Integer maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public String printClientMetadata() {
        this.init();
        return this.spMetadata;
    }
}

