/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso;

import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.security.SAMLProtocolMessageXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.binding.security.SAML2HTTPPostSimpleSignRule;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SamlException;
import org.pac4j.saml.util.SamlUtils;

public class Saml2WebSSOProfileHandler {
    private final CredentialProvider credentialProvider;
    private final MessageEncoder encoder;
    private final MessageDecoder decoder;
    private final StaticBasicParserPool parserPool;
    public static final String SAML2_WEBSSO_PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";

    public Saml2WebSSOProfileHandler(CredentialProvider credentialProvider, MessageEncoder encoder, MessageDecoder decoder, StaticBasicParserPool parserPool) {
        this.credentialProvider = credentialProvider;
        this.encoder = encoder;
        this.decoder = decoder;
        this.parserPool = parserPool;
    }

    public void sendMessage(SAMLMessageContext context, AuthnRequest authnRequest, String relayState) {
        boolean sign;
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
        SingleSignOnService ssoService = SamlUtils.getSingleSignOnService(idpssoDescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        context.setCommunicationProfileId(SAML2_WEBSSO_PROFILE_URI);
        context.setOutboundMessage((XMLObject)authnRequest);
        context.setOutboundSAMLMessage((SAMLObject)authnRequest);
        context.setPeerEntityEndpoint((Endpoint)ssoService);
        if (relayState != null) {
            context.setRelayState(relayState);
        }
        boolean bl = sign = spDescriptor.isAuthnRequestsSigned() != false || idpssoDescriptor.getWantAuthnRequestsSigned() != false;
        if (sign) {
            context.setOutboundSAMLMessageSigningCredential(this.credentialProvider.getCredential());
        }
        try {
            this.encoder.encode((MessageContext)context);
        }
        catch (MessageEncodingException e) {
            throw new SamlException("Error encoding saml message", e);
        }
    }

    public void receiveMessage(SAMLMessageContext context, SignatureTrustEngine engine) {
        context.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        context.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        BasicSecurityPolicy policy = new BasicSecurityPolicy();
        policy.getPolicyRules().add(new SAML2HTTPPostSimpleSignRule(engine, (ParserPool)this.parserPool, engine.getKeyInfoResolver()));
        policy.getPolicyRules().add(new SAMLProtocolMessageXMLSignatureSecurityPolicyRule((TrustEngine)engine));
        StaticSecurityPolicyResolver resolver = new StaticSecurityPolicyResolver((SecurityPolicy)policy);
        context.setSecurityPolicyResolver((SecurityPolicyResolver)resolver);
        try {
            this.decoder.decode((MessageContext)context);
        }
        catch (MessageDecodingException e) {
            throw new SamlException("Error decoding saml message", e);
        }
        catch (SecurityException e) {
            throw new SamlException("Error decoding saml message", e);
        }
        if (context.getPeerEntityMetadata() == null) {
            throw new SamlException("IDP Metadata cannot be null");
        }
        context.setPeerEntityId(context.getPeerEntityMetadata().getEntityID());
        context.setCommunicationProfileId(SAML2_WEBSSO_PROFILE_URI);
    }
}

