/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.util.ArrayList;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2ClientConfiguration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.DefaultSignatureSigningParametersProvider;
import org.pac4j.saml.crypto.ExplicitSignatureTrustEngineProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.crypto.KeyStoreDecryptionProvider;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.sso.SAML2ObjectBuilder;
import org.pac4j.saml.sso.SAML2ProfileHandler;
import org.pac4j.saml.sso.SAML2ResponseValidator;
import org.pac4j.saml.sso.impl.SAML2AuthnRequestBuilder;
import org.pac4j.saml.sso.impl.SAML2DefaultResponseValidator;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageReceiver;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageSender;
import org.pac4j.saml.sso.impl.SAML2WebSSOProfileHandler;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAML2Client
extends IndirectClient<SAML2Credentials, SAML2Profile> {
    protected static final Logger logger = LoggerFactory.getLogger(SAML2Client.class);
    public static final String SAML_RELAY_STATE_ATTRIBUTE = "samlRelayState";
    protected CredentialProvider credentialProvider;
    protected SAMLContextProvider contextProvider;
    protected SAML2ObjectBuilder<AuthnRequest> saml2ObjectBuilder;
    protected SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected SAML2ProfileHandler profileHandler;
    protected SAML2ResponseValidator responseValidator;
    protected SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected SAML2MetadataResolver idpMetadataResolver;
    protected SAML2MetadataResolver spMetadataResolver;
    protected Decrypter decrypter;
    protected SAML2ClientConfiguration configuration;

    public SAML2Client() {
    }

    public SAML2Client(SAML2ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        this.initCredentialProvider();
        this.initDecrypter();
        this.initSignatureSigningParametersProvider();
        ChainingMetadataResolver metadataManager = this.initChainingMetadataResolver(this.initIdentityProviderMetadataResolver(), this.initServiceProviderMetadataResolver(context));
        this.initSAMLContextProvider((MetadataResolver)metadataManager);
        this.initSAMLObjectBuilder();
        this.initSignatureTrustEngineProvider((MetadataResolver)metadataManager);
        this.initSAMLResponseValidator();
        this.initSAMLProfileHandler();
    }

    protected void initSAMLProfileHandler() {
        this.profileHandler = new SAML2WebSSOProfileHandler(new SAML2WebSSOMessageSender(this.signatureSigningParametersProvider, this.configuration.getDestinationBindingType(), false), new SAML2WebSSOMessageReceiver(this.responseValidator, this.credentialProvider));
    }

    protected void initSAMLResponseValidator() {
        this.responseValidator = new SAML2DefaultResponseValidator(this.signatureTrustEngineProvider, this.decrypter, this.configuration.getMaximumAuthenticationLifetime());
    }

    protected void initSignatureTrustEngineProvider(MetadataResolver metadataManager) {
        this.signatureTrustEngineProvider = new ExplicitSignatureTrustEngineProvider(metadataManager);
    }

    protected void initSAMLObjectBuilder() {
        this.saml2ObjectBuilder = new SAML2AuthnRequestBuilder(this.configuration.isForceAuth(), this.configuration.getComparisonType(), this.configuration.getDestinationBindingType(), this.configuration.getAuthnContextClassRef(), this.configuration.getNameIdPolicyFormat());
    }

    protected void initSAMLContextProvider(MetadataResolver metadataManager) {
        this.contextProvider = new SAML2ContextProvider(metadataManager, this.idpMetadataResolver, this.spMetadataResolver, this.configuration.getSamlMessageStorageFactory());
    }

    protected MetadataResolver initServiceProviderMetadataResolver(WebContext context) {
        this.spMetadataResolver = new SAML2ServiceProviderMetadataResolver(this.configuration.getServiceProviderMetadataPath(), this.computeFinalCallbackUrl(context), this.configuration.getServiceProviderEntityId(), this.configuration.isForceServiceProviderMetadataGeneration(), this.credentialProvider);
        return this.spMetadataResolver.resolve();
    }

    protected MetadataResolver initIdentityProviderMetadataResolver() {
        this.idpMetadataResolver = new SAML2IdentityProviderMetadataResolver(this.configuration.getIdentityProviderMetadataPath(), this.configuration.getIdentityProviderEntityId());
        return this.idpMetadataResolver.resolve();
    }

    protected void initCredentialProvider() {
        this.credentialProvider = new KeyStoreCredentialProvider(this.configuration.getKeystorePath(), this.configuration.getKeystorePassword(), this.configuration.getPrivateKeyPassword());
    }

    protected void initDecrypter() {
        this.decrypter = new KeyStoreDecryptionProvider(this.credentialProvider).build();
    }

    protected void initSignatureSigningParametersProvider() {
        this.signatureSigningParametersProvider = new DefaultSignatureSigningParametersProvider(this.credentialProvider, this.configuration);
    }

    protected ChainingMetadataResolver initChainingMetadataResolver(MetadataResolver idpMetadataProvider, MetadataResolver spMetadataProvider) {
        ChainingMetadataResolver metadataManager = new ChainingMetadataResolver();
        metadataManager.setId(ChainingMetadataResolver.class.getCanonicalName());
        try {
            ArrayList<MetadataResolver> list = new ArrayList<MetadataResolver>();
            list.add(idpMetadataProvider);
            list.add(spMetadataProvider);
            metadataManager.setResolvers(list);
            metadataManager.initialize();
        }
        catch (ResolverException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        catch (ComponentInitializationException e) {
            throw new TechnicalException("Error initializing manager", (Throwable)e);
        }
        return metadataManager;
    }

    protected BaseClient<SAML2Credentials, SAML2Profile> newClient() {
        return new SAML2Client(this.configuration.clone());
    }

    protected boolean isDirectRedirection() {
        return !this.configuration.getDestinationBindingType().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    protected RedirectAction retrieveRedirectAction(WebContext wc) {
        SAML2MessageContext context = this.contextProvider.buildContext(wc);
        String relayState = this.getStateParameter(wc);
        AuthnRequest authnRequest = this.saml2ObjectBuilder.build(context);
        this.profileHandler.send(context, authnRequest, relayState);
        Pac4jSAMLResponse adapter = context.getProfileRequestContextOutboundMessageTransportResponse();
        if (this.configuration.getDestinationBindingType().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String content = adapter.getOutgoingContent();
            return RedirectAction.success((String)content);
        }
        String location = adapter.getRedirectUrl();
        return RedirectAction.redirect((String)location);
    }

    protected SAML2Credentials retrieveCredentials(WebContext wc) throws RequiresHttpAction {
        SAML2MessageContext context = this.contextProvider.buildContext(wc);
        SAML2Credentials credentials = (SAML2Credentials)this.profileHandler.receive(context);
        credentials.setClientName(this.getName());
        return credentials;
    }

    protected SAML2Profile retrieveUserProfile(SAML2Credentials credentials, WebContext context) {
        SAML2Profile profile = new SAML2Profile();
        profile.setId(credentials.getNameId().getValue());
        for (Attribute attribute : credentials.getAttributes()) {
            logger.debug("Processing profile attribute {}", (Object)attribute);
            ArrayList<String> values = new ArrayList<String>();
            for (XMLObject attributeValue : attribute.getAttributeValues()) {
                Element attributeValueElement = attributeValue.getDOM();
                if (attributeValueElement != null) {
                    String value = attributeValueElement.getTextContent();
                    logger.debug("Adding attribute value {} for attribute {}", (Object)value, (Object)attribute.getFriendlyName());
                    values.add(value);
                    continue;
                }
                logger.warn("Attribute value DOM element is null for {}", (Object)attribute);
            }
            if (!values.isEmpty()) {
                profile.addAttribute(attribute.getName(), values);
                continue;
            }
            logger.debug("No attribute values found for {}", (Object)attribute.getName());
        }
        return profile;
    }

    protected String getStateParameter(WebContext webContext) {
        String relayState = (String)webContext.getSessionAttribute(SAML_RELAY_STATE_ATTRIBUTE);
        webContext.setSessionAttribute(SAML_RELAY_STATE_ATTRIBUTE, null);
        return relayState == null ? this.computeFinalCallbackUrl(webContext) : relayState;
    }

    public final SAML2ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public final SAML2MetadataResolver getServiceProviderMetadataResolver() {
        return this.spMetadataResolver;
    }

    public final SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        return this.idpMetadataResolver;
    }

    public final ClientType getClientType() {
        return ClientType.SAML_PROTOCOL;
    }

    public final String getIdentityProviderResolvedEntityId() {
        return this.idpMetadataResolver.getEntityId();
    }

    public final String getServiceProviderResolvedEntityId() {
        return this.spMetadataResolver.getEntityId();
    }

    public void setConfiguration(SAML2ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public final SAML2ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    static {
        CommonHelper.assertNotNull((String)"parserPool", (Object)Configuration.getParserPool());
        CommonHelper.assertNotNull((String)"marshallerFactory", (Object)Configuration.getMarshallerFactory());
        CommonHelper.assertNotNull((String)"unmarshallerFactory", (Object)Configuration.getUnmarshallerFactory());
        CommonHelper.assertNotNull((String)"builderFactory", (Object)Configuration.getBuilderFactory());
    }
}

