/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.util.XMLHelper;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2IdentityProviderMetadataResolver
implements SAML2MetadataResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String HTTP_PREFIX = "http";
    protected static final String FILE_PREFIX = "file:";
    private final String idpMetadataPath;
    private String idpEntityId;
    private DOMMetadataResolver idpMetadataProvider;

    public SAML2IdentityProviderMetadataResolver(String idpMetadataPath, @Nullable String idpEntityId) {
        this.idpMetadataPath = idpMetadataPath;
        this.idpEntityId = idpEntityId;
    }

    @Override
    public final MetadataResolver resolve() {
        if (this.idpMetadataProvider != null) {
            return this.idpMetadataProvider;
        }
        try {
            Resource resource = null;
            if (this.idpMetadataPath.startsWith("resource:")) {
                String path = this.idpMetadataPath.substring("resource:".length());
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                resource = ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource(path));
            } else if (this.idpMetadataPath.startsWith(HTTP_PREFIX)) {
                UrlResource urlResource = new UrlResource(this.idpMetadataPath);
                if (urlResource.getURL().getProtocol().equalsIgnoreCase(HTTP_PREFIX)) {
                    this.logger.warn("IdP metadata is retrieved from an insecure http endpoint [{}]", (Object)urlResource.getURL());
                }
                resource = ResourceHelper.of((org.springframework.core.io.Resource)urlResource);
            } else {
                resource = this.idpMetadataPath.startsWith(FILE_PREFIX) ? ResourceHelper.of((org.springframework.core.io.Resource)new FileSystemResource(this.idpMetadataPath.substring(FILE_PREFIX.length()))) : ResourceHelper.of((org.springframework.core.io.Resource)new FileSystemResource(this.idpMetadataPath));
            }
            if (resource == null) {
                throw new XMLParserException("idp metadata cannot be resolved from " + this.idpMetadataPath);
            }
            try (InputStream in = resource.getInputStream();){
                Document inCommonMDDoc = Configuration.getParserPool().parse(in);
                Element metadataRoot = inCommonMDDoc.getDocumentElement();
                this.idpMetadataProvider = new DOMMetadataResolver(metadataRoot);
                this.idpMetadataProvider.setParserPool(Configuration.getParserPool());
                this.idpMetadataProvider.setFailFastInitialization(true);
                this.idpMetadataProvider.setRequireValidMetadata(true);
                this.idpMetadataProvider.setId(this.idpMetadataProvider.getClass().getCanonicalName());
                this.idpMetadataProvider.initialize();
            }
            catch (FileNotFoundException e) {
                throw new TechnicalException("Error loading idp Metadata. The path must be a valid https url, begin with 'resource:' or it must be a physical readable non-empty local file at the path specified.", (Throwable)e);
            }
            if (this.idpEntityId == null) {
                for (EntityDescriptor entityDescriptor : this.idpMetadataProvider) {
                    if (this.idpEntityId != null) continue;
                    this.idpEntityId = entityDescriptor.getEntityID();
                }
            }
            if (this.idpEntityId == null) {
                throw new SAMLException("No idp entityId found");
            }
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
        catch (XMLParserException e) {
            throw new TechnicalException("Error parsing idp Metadata", (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Error getting idp Metadata resource", (Throwable)e);
        }
        return this.idpMetadataProvider;
    }

    @Override
    public String getEntityId() {
        XMLObject md = this.getEntityDescriptorElement();
        if (md instanceof EntitiesDescriptor) {
            Iterator iterator = ((EntitiesDescriptor)md).getEntityDescriptors().iterator();
            if (iterator.hasNext()) {
                EntityDescriptor entity = (EntityDescriptor)iterator.next();
                return entity.getEntityID();
            }
        } else if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SAMLException("No idp entityId found");
    }

    @Override
    public String getMetadataPath() {
        return this.idpMetadataPath;
    }

    @Override
    public String getMetadata() {
        if (this.getEntityDescriptorElement() != null && this.getEntityDescriptorElement().getDOM() != null) {
            return XMLHelper.nodeToString((Node)this.getEntityDescriptorElement().getDOM());
        }
        throw new TechnicalException("Metadata cannot be retrieved because entity descriptor is null");
    }

    @Override
    public final XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.idpEntityId)}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }
}

