/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.util.HashMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    protected static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static BasicParserPool parserPool;

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrap() {
        parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(100);
        parserPool.setCoalescing(true);
        parserPool.setIgnoreComments(true);
        parserPool.setNamespaceAware(true);
        HashMap builderAttributes = new HashMap();
        parserPool.setBuilderAttributes(builderAttributes);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        parserPool.setBuilderFeatures(features);
        try {
            parserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException("Exception initializing parserPool", e);
        }
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new RuntimeException("Exception initializing OpenSAML", e);
        }
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            registry.setParserPool((ParserPool)parserPool);
            return;
        }
    }

    public static ParserPool getParserPool() {
        return parserPool;
    }

    public static XMLObjectBuilderFactory getBuilderFactory() {
        return XMLObjectProviderRegistrySupport.getBuilderFactory();
    }

    public static MarshallerFactory getMarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getMarshallerFactory();
    }

    public static UnmarshallerFactory getUnmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    static {
        logger.info("Bootstrapping OpenSAML configuration via Pac4j...");
        Configuration.bootstrap();
    }
}

