/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredentialProvider
implements CredentialProvider {
    private final Logger logger = LoggerFactory.getLogger(KeyStoreCredentialProvider.class);
    private final CredentialResolver credentialResolver;
    private final String privateKey;

    public KeyStoreCredentialProvider(String name, String storePasswd, String privateKeyPasswd) {
        InputStream inputStream = CommonHelper.getInputStreamFromName((String)name);
        KeyStore keyStore = this.loadKeyStore(inputStream, storePasswd);
        this.privateKey = this.getPrivateKeyAlias(keyStore);
        HashMap<String, String> passwords = new HashMap<String, String>();
        passwords.put(this.privateKey, privateKeyPasswd);
        this.credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
    }

    @Override
    public KeyInfo getKeyInfo() {
        Credential serverCredential = this.getCredential();
        KeyInfo keyInfo = this.generateKeyInfoForCredential(serverCredential);
        return keyInfo;
    }

    @Override
    public final CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        return DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
    }

    @Override
    public final KeyInfoGenerator getKeyInfoGenerator() {
        NamedKeyInfoGeneratorManager mgmr = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        Credential credential = this.getCredential();
        return mgmr.getDefaultManager().getFactory(credential).newInstance();
    }

    @Override
    public final Credential getCredential() {
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIdCriterion criteria = new EntityIdCriterion(this.privateKey);
            cs.add((Object)criteria);
            X509Credential creds = (X509Credential)this.credentialResolver.resolveSingle((Object)cs);
            return creds;
        }
        catch (ResolverException e) {
            throw new SAMLException("Can't obtain SP private key", e);
        }
    }

    protected final KeyInfo generateKeyInfoForCredential(Credential credential) {
        try {
            return this.getKeyInfoGenerator().generate(credential);
        }
        catch (SecurityException e) {
            throw new SAMLException("Unable to generate keyInfo from given credential", e);
        }
    }

    private KeyStore loadKeyStore(InputStream inputStream, String storePasswd) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(inputStream, storePasswd == null ? null : storePasswd.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new SAMLException("Error loading keystore", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.debug("Error closing input stream of keystore", (Throwable)e);
                }
            }
        }
    }

    private String getPrivateKeyAlias(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                return aliases.nextElement();
            }
            throw new SAMLException("Keystore has no private keys");
        }
        catch (KeyStoreException e) {
            throw new SAMLException("Unable to get aliases from keyStore", e);
        }
    }
}

