/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriUtils {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final int DEFAULT_PORT_HTTP = 80;
    private static final int DEFAULT_PORT_HTTPS = 443;
    private static final Logger logger = LoggerFactory.getLogger(UriUtils.class);

    private UriUtils() {
    }

    public static boolean urisEqualAfterPortNormalization(URI uri1, URI uri2) {
        if (uri1 == null && uri2 == null) {
            return true;
        }
        if (uri1 == null && uri2 != null || uri1 != null && uri2 == null) {
            return false;
        }
        try {
            URI normalizedUri1 = UriUtils.normalizePortNumbersInUri(uri1);
            URI normalizedUri2 = UriUtils.normalizePortNumbersInUri(uri2);
            boolean eq = normalizedUri1.equals(normalizedUri2);
            return eq;
        }
        catch (URISyntaxException use) {
            logger.error("Cannot compare 2 URIs.", (Throwable)use);
            return false;
        }
    }

    private static URI normalizePortNumbersInUri(URI uri) throws URISyntaxException {
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if (SCHEME_HTTP.equals(scheme) && port == 80) {
            port = -1;
        }
        if (SCHEME_HTTPS.equals(scheme) && port == 443) {
            port = -1;
        }
        URI result = new URI(scheme, uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        return result;
    }
}

