/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.io.WritableResource;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2ClientConfiguration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ServiceProviderMetadataResolver
implements SAML2MetadataResolver {
    protected static final Logger logger = LoggerFactory.getLogger(SAML2ServiceProviderMetadataResolver.class);
    private final CredentialProvider credentialProvider;
    private String spEntityId;
    private final WritableResource spMetadataResource;
    private String spMetadata;
    private final String callbackUrl;
    private final boolean forceSpMetadataGeneration;

    public SAML2ServiceProviderMetadataResolver(String spMetadataPath, String callbackUrl, @Nullable String spEntityId, boolean forceSpMetadataGeneration, CredentialProvider credentialProvider) {
        this(spMetadataPath, null, callbackUrl, spEntityId, forceSpMetadataGeneration, credentialProvider);
    }

    public SAML2ServiceProviderMetadataResolver(SAML2ClientConfiguration configuration, String callbackUrl, CredentialProvider credentialProvider) {
        this(configuration.getServiceProviderMetadataPath(), configuration.getServiceProviderMetadataResource(), callbackUrl, configuration.getServiceProviderEntityId(), configuration.isForceServiceProviderMetadataGeneration(), credentialProvider);
    }

    private SAML2ServiceProviderMetadataResolver(String spMetadataPath, WritableResource spMetadataResource, String callbackUrl, @Nullable String spEntityId, boolean forceSpMetadataGeneration, CredentialProvider credentialProvider) {
        this.spMetadataResource = spMetadataResource != null ? spMetadataResource : (WritableResource)CommonHelper.getResource((String)spMetadataPath);
        this.spEntityId = spEntityId;
        this.credentialProvider = credentialProvider;
        this.callbackUrl = callbackUrl;
        this.forceSpMetadataGeneration = forceSpMetadataGeneration;
        try {
            if (CommonHelper.isBlank((String)this.spEntityId)) {
                URL url = new URL(callbackUrl);
                this.spEntityId = url.getQuery() != null ? url.toString().replace("?" + url.getQuery(), "") : url.toString();
            }
            logger.info("Using SP entity ID {}", (Object)this.spEntityId);
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    @Override
    public final MetadataResolver resolve() {
        try {
            SAML2MetadataGenerator metadataGenerator = new SAML2MetadataGenerator();
            if (this.credentialProvider != null) {
                metadataGenerator.setCredentialProvider(this.credentialProvider);
                metadataGenerator.setAuthnRequestSigned(true);
            }
            metadataGenerator.setEntityId(this.spEntityId);
            metadataGenerator.setRequestInitiatorLocation(this.callbackUrl);
            metadataGenerator.setAssertionConsumerServiceUrl(this.callbackUrl);
            metadataGenerator.setSingleLogoutServiceUrl(this.callbackUrl);
            MetadataResolver spMetadataProvider = metadataGenerator.buildMetadataResolver();
            this.spMetadata = metadataGenerator.getMetadata();
            if (this.spMetadataResource != null) {
                if (this.spMetadataResource.exists() && !this.forceSpMetadataGeneration) {
                    logger.info("Metadata file already exists at {}.", (Object)this.spMetadataResource.getFilename());
                } else {
                    logger.info("Writing sp metadata to {}", (Object)this.spMetadataResource.getFilename());
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    StreamResult result = new StreamResult(new StringWriter());
                    StreamSource source = new StreamSource(new StringReader(this.spMetadata));
                    transformer.transform(source, result);
                    try (OutputStream spMetadataOutputStream = this.spMetadataResource.getOutputStream();){
                        spMetadataOutputStream.write(result.getWriter().toString().getBytes("UTF-8"));
                    }
                }
            }
            return spMetadataProvider;
        }
        catch (ComponentInitializationException e) {
            throw new TechnicalException("Error initializing spMetadataProvider", (Throwable)e);
        }
        catch (MarshallingException e) {
            logger.warn("Unable to marshal SP metadata", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Unable to print SP metadata", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Unable to transform metadata", (Throwable)e);
        }
        return null;
    }

    @Override
    public final String getEntityId() {
        return this.spEntityId;
    }

    @Override
    public String getMetadataPath() {
        return this.spMetadataResource.getFilename();
    }

    @Override
    public String getMetadata() {
        return this.spMetadata;
    }

    @Override
    public XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.getEntityId())}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }
}

