/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Pac4jHTTPPostEncoder
extends AbstractMessageEncoder<SAMLObject> {
    private static final Logger log = LoggerFactory.getLogger(Pac4jHTTPPostEncoder.class);
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml2-post-binding.vm";
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;
    private final Pac4jSAMLResponse responseAdapter;

    public Pac4jHTTPPostEncoder(Pac4jSAMLResponse responseAdapter) {
        this.responseAdapter = responseAdapter;
        this.setVelocityTemplateId(DEFAULT_TEMPLATE_ID);
    }

    public void setVelocityTemplateId(String newVelocityTemplateId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityTemplateId = newVelocityTemplateId;
    }

    protected void doDestroy() {
        this.velocityEngine = null;
        this.velocityTemplateId = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        log.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine must be supplied");
        }
        if (this.velocityTemplateId == null) {
            throw new ComponentInitializationException("Velocity template id must be supplied");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL((MessageContext<SAMLObject>)messageContext).toString();
        this.postEncode((MessageContext<SAMLObject>)messageContext, endpointURL);
    }

    protected URI getEndpointURL(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        try {
            return SAMLBindingSupport.getEndpointURL(messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
    }

    protected void postEncode(MessageContext<SAMLObject> messageContext, String endpointURL) throws MessageEncodingException {
        log.debug("Invoking Velocity template to create POST body");
        try {
            VelocityContext e = new VelocityContext();
            this.populateVelocityContext(e, messageContext, endpointURL);
            this.responseAdapter.setContentType("text/html");
            this.responseAdapter.init();
            OutputStreamWriter out = this.responseAdapter.getOutputStreamWriter();
            this.getVelocityEngine().mergeTemplate(this.getVelocityTemplateId(), "UTF-8", (Context)e, (Writer)out);
            out.flush();
        }
        catch (Exception var6) {
            throw new MessageEncodingException("Error creating output document", var6);
        }
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    protected void populateVelocityContext(VelocityContext velocityContext, MessageContext<SAMLObject> messageContext, String endpointURL) throws MessageEncodingException {
        block5: {
            String encodedEndpointURL = HTMLEncoder.encodeForHTMLAttribute((String)endpointURL);
            log.debug("Encoding action url of '{}' with encoded value '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
            velocityContext.put("action", (Object)encodedEndpointURL);
            velocityContext.put("binding", (Object)this.getBindingURI());
            SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
            log.debug("Marshalling and Base64 encoding SAML message");
            Element domMessage = this.marshallMessage((XMLObject)outboundMessage);
            try {
                String messageXML = SerializeSupport.nodeToString((Node)domMessage);
                String encodedMessage = Base64Support.encode((byte[])messageXML.getBytes("UTF-8"), (boolean)false);
                if (outboundMessage instanceof RequestAbstractType) {
                    velocityContext.put("SAMLRequest", (Object)encodedMessage);
                    break block5;
                }
                if (outboundMessage instanceof StatusResponseType) {
                    velocityContext.put("SAMLResponse", (Object)encodedMessage);
                    break block5;
                }
                throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
            }
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute((String)relayState);
            log.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            velocityContext.put("RelayState", (Object)encodedRelayState);
        }
    }

    public void setVelocityEngine(VelocityEngine newVelocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityEngine = newVelocityEngine;
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }
}

