/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Pac4jHTTPRedirectDeflateEncoder
extends AbstractMessageEncoder<SAMLObject> {
    private static final Logger log = LoggerFactory.getLogger(Pac4jHTTPPostEncoder.class);
    private final Pac4jSAMLResponse responseAdapter;

    public Pac4jHTTPRedirectDeflateEncoder(Pac4jSAMLResponse responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        String endpointURL = this.getEndpointURL((MessageContext<SAMLObject>)messageContext).toString();
        this.removeSignature(outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode(outboundMessage);
        String redirectURL = this.buildRedirectURL((MessageContext<SAMLObject>)messageContext, endpointURL, encodedMessage);
        this.responseAdapter.init();
        this.responseAdapter.setRedirectUrl(redirectURL);
    }

    protected void doInitialize() throws ComponentInitializationException {
        log.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected URI getEndpointURL(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        try {
            return SAMLBindingSupport.getEndpointURL(messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
    }

    protected void removeSignature(SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            log.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    protected String deflateAndBase64Encode(SAMLObject message) throws MessageEncodingException {
        log.debug("Deflating and Base64 encoding SAML message");
        try {
            String messageStr = SerializeSupport.nodeToString((Node)this.marshallMessage((XMLObject)message));
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            deflaterStream.write(messageStr.getBytes("UTF-8"));
            deflaterStream.finish();
            return Base64Support.encode((byte[])bytesOut.toByteArray(), (boolean)false);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", (Exception)e);
        }
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }

    protected String buildRedirectURL(MessageContext<SAMLObject> messageContext, String endpoint, String message) throws MessageEncodingException {
        SignatureSigningParameters signingParameters;
        log.debug("Building URL to redirect client to");
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        List queryParams = urlBuilder.getQueryParams();
        queryParams.clear();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        if ((signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext)) != null && signingParameters.getSigningCredential() != null) {
            String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
            Pair sigAlg = new Pair((Object)"SigAlg", (Object)sigAlgURI);
            queryParams.add(sigAlg);
            String sigMaterial = urlBuilder.buildQueryString();
            queryParams.add(new Pair((Object)"Signature", (Object)this.generateSignature(signingParameters.getSigningCredential(), sigAlgURI, sigMaterial)));
        } else {
            log.debug("No signing credential was supplied, skipping HTTP-Redirect DEFLATE signing");
        }
        return urlBuilder.buildURL();
    }

    protected String getSignatureAlgorithmURI(SignatureSigningParameters signingParameters) throws MessageEncodingException {
        if (signingParameters.getSignatureAlgorithm() != null) {
            return signingParameters.getSignatureAlgorithm();
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
        log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over query string '%s'", CredentialSupport.extractSigningKey((Credential)signingCredential).getAlgorithm(), algorithmURI, queryString));
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])queryString.getBytes("UTF-8"));
            b64Signature = Base64Support.encode((byte[])rawSignature, (boolean)false);
            log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            throw new MessageEncodingException("Unable to sign URL query string", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new TechnicalException((Throwable)e);
        }
        return b64Signature;
    }
}

