/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.pac4j.core.credentials.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAML2Credentials
extends Credentials {
    private static final Logger logger = LoggerFactory.getLogger(SAML2Credentials.class);
    private static final long serialVersionUID = 5040516205957826527L;
    private SAMLNameID nameId = new SAMLNameID();
    private String sessionIndex;
    private List<SAMLAttribute> attributes;
    private SAMLConditions conditions;
    private String issuerId;
    private List<String> authnContexts;

    public SAML2Credentials(NameID nameId, String issuerId, List<Attribute> samlAttributes, Conditions conditions, String sessionIndex, List<String> authnContexts) {
        this.nameId.setNameQualifier(nameId.getNameQualifier());
        this.nameId.setFormat(nameId.getFormat());
        this.nameId.setSpNameQualifier(nameId.getSPNameQualifier());
        this.nameId.setSpProviderId(nameId.getSPProvidedID());
        this.nameId.setValue(nameId.getValue());
        this.issuerId = issuerId;
        this.sessionIndex = sessionIndex;
        this.attributes = new ArrayList<SAMLAttribute>();
        samlAttributes.forEach(attribute -> {
            SAMLAttribute samlAttribute = new SAMLAttribute();
            samlAttribute.setFriendlyName(attribute.getFriendlyName());
            samlAttribute.setName(attribute.getName());
            samlAttribute.setNameFormat(attribute.getNameFormat());
            attribute.getAttributeValues().forEach(xmlObject -> {
                Element dom = xmlObject.getDOM();
                if (dom != null && dom.getTextContent() != null) {
                    samlAttribute.getAttributeValues().add(dom.getTextContent());
                }
            });
            this.attributes.add(samlAttribute);
        });
        this.conditions = new SAMLConditions();
        this.conditions.setNotBefore(conditions.getNotBefore());
        this.conditions.setNotOnOrAfter(conditions.getNotOnOrAfter());
        this.authnContexts = authnContexts;
        logger.info("Constructed SAML2 credentials: {}", (Object)this);
    }

    public final SAMLNameID getNameId() {
        return this.nameId;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final List<SAMLAttribute> getAttributes() {
        return this.attributes;
    }

    public SAMLConditions getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SAML2Credentials that = (SAML2Credentials)((Object)o);
        if (this.nameId != null ? !this.nameId.equals(that.nameId) : that.nameId != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.sessionIndex != null ? this.sessionIndex.equals(that.sessionIndex) : that.sessionIndex != null) {
            return false;
        }
        return !(this.conditions == null ? that.conditions != null : !this.conditions.equals(that.conditions));
    }

    public int hashCode() {
        int result = this.nameId != null ? this.nameId.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.sessionIndex != null ? this.sessionIndex.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SAML2Credentials{nameId=" + this.nameId + ", sessionIndex='" + this.sessionIndex + '\'' + ", attributes=" + this.attributes + ", conditions=" + this.conditions + ", issuerId='" + this.issuerId + '\'' + ", authnContexts=" + this.authnContexts + '}';
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public List<String> getAuthnContexts() {
        return this.authnContexts;
    }

    public static class SAMLConditions
    implements Serializable {
        private static final long serialVersionUID = -8966585574672014553L;
        private DateTime notBefore;
        private DateTime notOnOrAfter;

        public DateTime getNotBefore() {
            return this.notBefore;
        }

        public void setNotBefore(DateTime notBefore) {
            this.notBefore = notBefore;
        }

        public DateTime getNotOnOrAfter() {
            return this.notOnOrAfter;
        }

        public void setNotOnOrAfter(DateTime notOnOrAfter) {
            this.notOnOrAfter = notOnOrAfter;
        }

        public String toString() {
            return "SAMLConditions{notBefore=" + this.notBefore + ", notOnOrAfter=" + this.notOnOrAfter + '}';
        }
    }

    public static class SAMLAttribute
    implements Serializable {
        private static final long serialVersionUID = 2532838901563948260L;
        private String friendlyName;
        private String name;
        private String nameFormat;
        private List<String> attributeValues = new ArrayList<String>();

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameFormat() {
            return this.nameFormat;
        }

        public void setNameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
        }

        public List<String> getAttributeValues() {
            return this.attributeValues;
        }

        public void setAttributeValues(List<String> attributeValues) {
            this.attributeValues = attributeValues;
        }

        public String toString() {
            return "SAMLAttribute{friendlyName='" + this.friendlyName + '\'' + ", name='" + this.name + '\'' + ", nameFormat='" + this.nameFormat + '\'' + ", attributeValues=" + this.attributeValues + '}';
        }
    }

    public static class SAMLNameID
    implements Serializable {
        private static final long serialVersionUID = -7913473743778305079L;
        private String format;
        private String nameQualifier;
        private String spNameQualifier;
        private String spProviderId;
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getSpNameQualifier() {
            return this.spNameQualifier;
        }

        public void setSpNameQualifier(String spNameQualifier) {
            this.spNameQualifier = spNameQualifier;
        }

        public String getSpProviderId() {
            return this.spProviderId;
        }

        public void setSpProviderId(String spProviderId) {
            this.spProviderId = spProviderId;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getNameQualifier() {
            return this.nameQualifier;
        }

        public void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        public String toString() {
            return "SAMLNameID{format='" + this.format + '\'' + ", nameQualifier='" + this.nameQualifier + '\'' + ", spNameQualifier='" + this.spNameQualifier + '\'' + ", spProviderId='" + this.spProviderId + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

