/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2MessageContext
extends MessageContext<SAMLObject> {
    private WebContext webContext;
    private Assertion subjectAssertion;
    private BaseID baseID;
    private final List<SubjectConfirmation> subjectConfirmations = new ArrayList<SubjectConfirmation>();
    private SAMLMessageStore samlMessageStore;

    public SAML2MessageContext() {
    }

    public SAML2MessageContext(MessageContext<SAMLObject> ctx) {
        this();
        super.setParent(ctx);
    }

    public WebContext getWebContext() {
        return this.webContext;
    }

    public void setWebContext(WebContext webContext) {
        this.webContext = webContext;
    }

    public final Assertion getSubjectAssertion() {
        return this.subjectAssertion;
    }

    public final SPSSODescriptor getSPSSODescriptor() {
        SAMLMetadataContext selfContext = this.getSAMLSelfMetadataContext();
        SPSSODescriptor spDescriptor = (SPSSODescriptor)selfContext.getRoleDescriptor();
        return spDescriptor;
    }

    public final IDPSSODescriptor getIDPSSODescriptor() {
        SAMLMetadataContext peerContext = this.getSAMLPeerMetadataContext();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)peerContext.getRoleDescriptor();
        return idpssoDescriptor;
    }

    public final SingleLogoutService getIDPSingleLogoutService(String binding) {
        List services = this.getIDPSSODescriptor().getSingleLogoutServices();
        for (SingleLogoutService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service;
        }
        throw new SAMLException("Identity provider has no single logout service available for the selected profile" + binding);
    }

    public SingleSignOnService getIDPSingleSignOnService(String binding) {
        List services = this.getIDPSSODescriptor().getSingleSignOnServices();
        for (SingleSignOnService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service;
        }
        throw new SAMLException("Identity provider has no single sign on service available for the selected profile" + binding);
    }

    public AssertionConsumerService getSPAssertionConsumerService() {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        return this.getSPAssertionConsumerService(spssoDescriptor, spssoDescriptor.getAssertionConsumerServices());
    }

    public AssertionConsumerService getSPAssertionConsumerService(Response response) {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        List services = spssoDescriptor.getAssertionConsumerServices();
        if (response != null && StringUtils.isNotEmpty((String)response.getDestination())) {
            for (AssertionConsumerService service : services) {
                if (!response.getDestination().equals(service.getLocation())) continue;
                return service;
            }
            throw new SAMLException("Assertion consumer service with sdestination " + response.getDestination() + " could not be found for spDescriptor " + spssoDescriptor);
        }
        return this.getSPAssertionConsumerService(spssoDescriptor, services);
    }

    public AssertionConsumerService getSPAssertionConsumerService(String acsIndex) {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        List services = spssoDescriptor.getAssertionConsumerServices();
        if (acsIndex != null) {
            for (AssertionConsumerService service : services) {
                if (!Integer.valueOf(acsIndex).equals(service.getIndex())) continue;
                return service;
            }
            throw new SAMLException("Assertion consumer service with index " + acsIndex + " could not be found for spDescriptor " + spssoDescriptor);
        }
        return this.getSPAssertionConsumerService(spssoDescriptor, services);
    }

    protected AssertionConsumerService getSPAssertionConsumerService(SPSSODescriptor spssoDescriptor, List<AssertionConsumerService> services) {
        if (spssoDescriptor.getDefaultAssertionConsumerService() != null) {
            return spssoDescriptor.getDefaultAssertionConsumerService();
        }
        if (!services.isEmpty()) {
            return services.iterator().next();
        }
        throw new SAMLException("No assertion consumer services could be found for " + spssoDescriptor);
    }

    public final ProfileRequestContext getProfileRequestContext() {
        return (ProfileRequestContext)this.getSubcontext(ProfileRequestContext.class, true);
    }

    public final SAMLSelfEntityContext getSAMLSelfEntityContext() {
        return (SAMLSelfEntityContext)this.getSubcontext(SAMLSelfEntityContext.class, true);
    }

    public final SOAP11Context getSOAP11Context() {
        return (SOAP11Context)this.getSubcontext(SOAP11Context.class, true);
    }

    public final SAMLMetadataContext getSAMLSelfMetadataContext() {
        return (SAMLMetadataContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLMetadataContext.class, true);
    }

    public final SAMLMetadataContext getSAMLPeerMetadataContext() {
        return (SAMLMetadataContext)this.getSAMLPeerEntityContext().getSubcontext(SAMLMetadataContext.class, true);
    }

    public final SAMLPeerEntityContext getSAMLPeerEntityContext() {
        return (SAMLPeerEntityContext)this.getSubcontext(SAMLPeerEntityContext.class, true);
    }

    public final SAMLSubjectNameIdentifierContext getSAMLSubjectNameIdentifierContext() {
        return (SAMLSubjectNameIdentifierContext)this.getSubcontext(SAMLSubjectNameIdentifierContext.class, true);
    }

    public final void setSubjectAssertion(Assertion subjectAssertion) {
        this.subjectAssertion = subjectAssertion;
    }

    public final BaseID getBaseID() {
        return this.baseID;
    }

    public final void setBaseID(BaseID baseID) {
        this.baseID = baseID;
    }

    public final List<SubjectConfirmation> getSubjectConfirmations() {
        return this.subjectConfirmations;
    }

    public final SAMLEndpointContext getSAMLPeerEndpointContext() {
        return (SAMLEndpointContext)this.getSAMLPeerEntityContext().getSubcontext(SAMLEndpointContext.class, true);
    }

    public final SAMLEndpointContext getSAMLSelfEndpointContext() {
        return (SAMLEndpointContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLEndpointContext.class, true);
    }

    public final SAMLBindingContext getSAMLBindingContext() {
        return (SAMLBindingContext)this.getSubcontext(SAMLBindingContext.class, true);
    }

    public final SecurityParametersContext getSecurityParametersContext() {
        return (SecurityParametersContext)this.getSubcontext(SecurityParametersContext.class, true);
    }

    public final SAMLProtocolContext getSAMLSelfProtocolContext() {
        return (SAMLProtocolContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLProtocolContext.class, true);
    }

    public final SAMLProtocolContext getSAMLProtocolContext() {
        return (SAMLProtocolContext)this.getSubcontext(SAMLProtocolContext.class, true);
    }

    public final Pac4jSAMLResponse getProfileRequestContextOutboundMessageTransportResponse() {
        return (Pac4jSAMLResponse)this.getProfileRequestContext().getOutboundMessageContext().getMessage();
    }

    public final SAMLEndpointContext getSAMLEndpointContext() {
        return (SAMLEndpointContext)this.getSubcontext(SAMLEndpointContext.class, true);
    }

    public final SAMLMessageStore getSAMLMessageStore() {
        return this.samlMessageStore;
    }

    public final void setSAMLMessageStore(SAMLMessageStore samlMessageStore) {
        this.samlMessageStore = samlMessageStore;
    }
}

