/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.io.FileUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAMLMetadataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class SAML2ServiceProviderMetadataResolver
implements SAML2MetadataResolver {
    public static final String LOGOUT_ENDPOINT_PARAMETER = "logoutendpoint";
    protected static final Logger logger = LoggerFactory.getLogger(SAML2ServiceProviderMetadataResolver.class);
    protected final CredentialProvider credentialProvider;
    protected final String callbackUrl;
    protected final SAML2Configuration configuration;
    private String spMetadata;
    private MetadataResolver metadataResolver;

    public SAML2ServiceProviderMetadataResolver(SAML2Configuration configuration, String callbackUrl, CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
        this.callbackUrl = callbackUrl;
        this.configuration = configuration;
        this.determineServiceProviderEntityId(callbackUrl);
    }

    public void destroy() {
        if (this.metadataResolver instanceof FilesystemMetadataResolver) {
            ((FilesystemMetadataResolver)this.metadataResolver).destroy();
            this.metadataResolver = null;
        }
    }

    private void determineServiceProviderEntityId(String callbackUrl) {
        try {
            if (CommonHelper.isBlank((String)this.configuration.getServiceProviderEntityId())) {
                URL url = new URL(callbackUrl);
                if (url.getQuery() != null) {
                    this.configuration.setServiceProviderEntityId(url.toString().replace("?" + url.getQuery(), ""));
                } else {
                    this.configuration.setServiceProviderEntityId(url.toString());
                }
            }
            logger.info("Using SP entity ID {}", (Object)this.configuration.getServiceProviderEntityId());
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected MetadataResolver prepareServiceProviderMetadata() {
        try {
            String tempMetadata;
            SAMLMetadataGenerator metadataGenerator = this.buildMetadataGenerator();
            EntityDescriptor entity = metadataGenerator.buildEntityDescriptor();
            this.spMetadata = tempMetadata = metadataGenerator.getMetadata(entity);
            this.writeServiceProviderMetadataToResource(tempMetadata);
            return metadataGenerator.buildMetadataResolver((Resource)this.configuration.getServiceProviderMetadataResource());
        }
        catch (Exception e) {
            throw new TechnicalException("Unable to generate metadata for service provider", (Throwable)e);
        }
    }

    protected SAMLMetadataGenerator buildMetadataGenerator() {
        SAML2MetadataGenerator metadataGenerator = new SAML2MetadataGenerator();
        this.fillSAML2MetadataGenerator(metadataGenerator);
        return metadataGenerator;
    }

    protected void fillSAML2MetadataGenerator(SAML2MetadataGenerator metadataGenerator) {
        metadataGenerator.setWantAssertionSigned(this.configuration.isWantsAssertionsSigned());
        metadataGenerator.setAuthnRequestSigned(this.configuration.isAuthnRequestSigned());
        metadataGenerator.setSignMetadata(this.configuration.isSignMetadata());
        metadataGenerator.setNameIdPolicyFormat(this.configuration.getNameIdPolicyFormat());
        metadataGenerator.setRequestedAttributes(this.configuration.getRequestedServiceProviderAttributes());
        metadataGenerator.setCredentialProvider(this.credentialProvider);
        metadataGenerator.setEntityId(this.configuration.getServiceProviderEntityId());
        metadataGenerator.setRequestInitiatorLocation(this.callbackUrl);
        metadataGenerator.setAssertionConsumerServiceUrl(this.callbackUrl);
        metadataGenerator.setResponseBindingType(this.configuration.getResponseBindingType());
        String logoutUrl = CommonHelper.addParameter((String)this.callbackUrl, (String)LOGOUT_ENDPOINT_PARAMETER, (String)"true");
        metadataGenerator.setSingleLogoutServiceUrl(logoutUrl);
        metadataGenerator.setBlackListedSignatureSigningAlgorithms(new ArrayList<String>(this.configuration.getBlackListedSignatureSigningAlgorithms()));
        metadataGenerator.setSignatureAlgorithms(this.configuration.getSignatureAlgorithms());
        metadataGenerator.setSignatureReferenceDigestMethods(this.configuration.getSignatureReferenceDigestMethods());
        metadataGenerator.setSupportedProtocols(this.configuration.getSupportedProtocols());
        metadataGenerator.setContactPersons(this.configuration.getContactPersons());
        metadataGenerator.setMetadataUIInfos(this.configuration.getMetadataUIInfos());
    }

    private void writeServiceProviderMetadataToResource(String tempMetadata) throws Exception {
        WritableResource metadataResource = this.configuration.getServiceProviderMetadataResource();
        if (metadataResource != null && CommonHelper.isNotBlank((String)tempMetadata)) {
            if (metadataResource.exists() && !this.configuration.isForceServiceProviderMetadataGeneration()) {
                logger.info("Metadata file already exists at {}.", (Object)metadataResource.getFile());
            } else {
                logger.info("Writing sp metadata to {}", (Object)metadataResource.getFilename());
                File parent = metadataResource.getFile().getParentFile();
                if (parent != null) {
                    logger.info("Attempting to create directory structure for: {}", (Object)parent.getCanonicalPath());
                    if (!parent.exists() && !parent.mkdirs()) {
                        logger.warn("Could not construct the directory structure for SP metadata: {}", (Object)parent.getCanonicalPath());
                    }
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                StreamResult result = new StreamResult(new StringWriter());
                StreamSource source = new StreamSource(new StringReader(tempMetadata));
                transformer.transform(source, result);
                try (OutputStream spMetadataOutputStream = metadataResource.getOutputStream();){
                    spMetadataOutputStream.write(result.getWriter().toString().getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    @Override
    public final MetadataResolver resolve() {
        if (this.metadataResolver == null) {
            this.metadataResolver = this.prepareServiceProviderMetadata();
        }
        return this.metadataResolver;
    }

    @Override
    public final String getEntityId() {
        return this.configuration.getServiceProviderEntityId();
    }

    @Override
    public String getMetadata() throws IOException {
        if (this.configuration.getServiceProviderMetadataResource() != null) {
            return FileUtils.readFileToString((File)this.configuration.getServiceProviderMetadataResource().getFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.spMetadata != null) {
            return this.spMetadata;
        }
        return null;
    }

    @Override
    public XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.getEntityId())}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }
}

