/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2MessageReceiver;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.transport.AbstractPac4jDecoder;

public abstract class AbstractSAML2MessageReceiver
implements SAML2MessageReceiver {
    protected final SAML2ResponseValidator validator;

    public AbstractSAML2MessageReceiver(SAML2ResponseValidator validator) {
        this.validator = validator;
    }

    @Override
    public Credentials receiveMessage(SAML2MessageContext context) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        WebContext webContext = context.getWebContext();
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        context.getSAMLSelfProtocolContext().setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        AbstractPac4jDecoder decoder = this.getDecoder(webContext);
        SAML2MessageContext decodedCtx = new SAML2MessageContext((MessageContext<SAMLObject>)decoder.getMessageContext());
        SAMLObject message = (SAMLObject)decoder.getMessageContext().getMessage();
        decodedCtx.setMessage(message);
        context.setMessage(message);
        decodedCtx.setSAMLMessageStore(context.getSAMLMessageStore());
        SAMLBindingContext bindingContext = (SAMLBindingContext)decodedCtx.getParent().getSubcontext(SAMLBindingContext.class);
        decodedCtx.getSAMLBindingContext().setBindingDescriptor(bindingContext.getBindingDescriptor());
        decodedCtx.getSAMLBindingContext().setBindingUri(bindingContext.getBindingUri());
        decodedCtx.getSAMLBindingContext().setHasBindingSignature(bindingContext.hasBindingSignature());
        decodedCtx.getSAMLBindingContext().setIntendedDestinationEndpointURIRequired(bindingContext.isIntendedDestinationEndpointURIRequired());
        String relayState = bindingContext.getRelayState();
        decodedCtx.getSAMLBindingContext().setRelayState(relayState);
        context.getSAMLBindingContext().setRelayState(relayState);
        AssertionConsumerService acsService = context.getSPAssertionConsumerService((Response)decodedCtx.getMessage());
        decodedCtx.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        EntityDescriptor metadata = context.getSAMLPeerMetadataContext().getEntityDescriptor();
        if (metadata == null) {
            throw new SAMLException("IDP Metadata cannot be null");
        }
        SAMLPeerEntityContext decodedPeerContext = (SAMLPeerEntityContext)decodedCtx.getParent().getSubcontext(SAMLPeerEntityContext.class);
        decodedCtx.getSAMLPeerEntityContext().setEntityId(metadata.getEntityID());
        decodedCtx.getSAMLPeerEntityContext().setAuthenticated(decodedPeerContext != null && decodedPeerContext.isAuthenticated());
        decodedCtx.getSAMLSelfEntityContext().setEntityId(context.getSAMLSelfEntityContext().getEntityId());
        decodedCtx.getSAMLSelfEndpointContext().setEndpoint(context.getSAMLSelfEndpointContext().getEndpoint());
        decodedCtx.getSAMLSelfEntityContext().setRole(context.getSAMLSelfEntityContext().getRole());
        decodedCtx.getProfileRequestContext().setProfileId(this.getProfileUri());
        decodedCtx.getSAMLSelfMetadataContext().setRoleDescriptor((RoleDescriptor)context.getSPSSODescriptor());
        decodedCtx.setWebContext(context.getWebContext());
        return this.validator.validate(decodedCtx);
    }

    protected abstract AbstractPac4jDecoder getDecoder(WebContext var1);

    protected abstract String getProfileUri();
}

