/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.api.SAML2ObjectBuilder;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2AuthnRequestBuilder
implements SAML2ObjectBuilder<AuthnRequest> {
    private final SAML2Configuration configuration;
    private int issueInstantSkewSeconds = 0;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public SAML2AuthnRequestBuilder(SAML2Configuration cfg) {
        this.configuration = cfg;
    }

    @Override
    public AuthnRequest build(SAML2MessageContext context) {
        SingleSignOnService ssoService = context.getIDPSingleSignOnService(this.configuration.getAuthnRequestBindingType());
        String idx = this.configuration.getAssertionConsumerServiceIndex() > 0 ? String.valueOf(this.configuration.getAssertionConsumerServiceIndex()) : null;
        AssertionConsumerService assertionConsumerService = context.getSPAssertionConsumerService(idx);
        return this.buildAuthnRequest(context, assertionConsumerService, ssoService);
    }

    protected final AuthnRequest buildAuthnRequest(SAML2MessageContext context, AssertionConsumerService assertionConsumerService, SingleSignOnService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        AuthnContextComparisonTypeEnumeration comparisonType = this.getComparisonTypeEnumFromString(this.configuration.getComparisonType());
        if (comparisonType != null) {
            RequestedAuthnContext authnContext = new RequestedAuthnContextBuilder().buildObject();
            authnContext.setComparison(comparisonType);
            if (this.configuration.getAuthnContextClassRefs() != null && !this.configuration.getAuthnContextClassRefs().isEmpty()) {
                List refs = authnContext.getAuthnContextClassRefs();
                this.configuration.getAuthnContextClassRefs().forEach(r -> refs.add(this.buildAuthnContextClassRef((String)r)));
            }
            request.setRequestedAuthnContext(authnContext);
        }
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(SAML2Utils.generateID());
        request.setIssuer(this.getIssuer(selfContext.getEntityId()));
        request.setIssueInstant(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(this.issueInstantSkewSeconds));
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIsPassive(Boolean.valueOf(this.configuration.isPassive()));
        request.setForceAuthn(Boolean.valueOf(this.configuration.isForceAuth()));
        if (StringUtils.isNotBlank((String)this.configuration.getProviderName())) {
            request.setProviderName(this.configuration.getProviderName());
        }
        if (this.configuration.getNameIdPolicyFormat() != null) {
            NameIDPolicy nameIdPolicy = new NameIDPolicyBuilder().buildObject();
            if (this.configuration.isNameIdPolicyAllowCreate() != null) {
                nameIdPolicy.setAllowCreate(this.configuration.isNameIdPolicyAllowCreate());
            }
            nameIdPolicy.setFormat(this.configuration.getNameIdPolicyFormat());
            request.setNameIDPolicy(nameIdPolicy);
        }
        request.setDestination(ssoService.getLocation());
        if (this.configuration.getAssertionConsumerServiceIndex() >= 0) {
            request.setAssertionConsumerServiceIndex(Integer.valueOf(this.configuration.getAssertionConsumerServiceIndex()));
        } else {
            request.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        }
        request.setProtocolBinding(assertionConsumerService.getBinding());
        if (this.configuration.getAttributeConsumingServiceIndex() >= 0) {
            request.setAttributeConsumingServiceIndex(Integer.valueOf(this.configuration.getAttributeConsumingServiceIndex()));
        }
        if (this.configuration.getAuthnRequestExtensions() != null) {
            Extensions extensionsElem = (Extensions)((SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME)).buildObject();
            extensionsElem.getUnknownXMLObjects().addAll((Collection)this.configuration.getAuthnRequestExtensions().get());
            request.setExtensions(extensionsElem);
        }
        return request;
    }

    protected AuthnContextClassRef buildAuthnContextClassRef(String authnContextClassRef) {
        AuthnContextClassRef classRef = new AuthnContextClassRefBuilder().buildObject();
        classRef.setAuthnContextClassRef(authnContextClassRef);
        return classRef;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        if (this.configuration.isUseNameQualifier()) {
            issuer.setNameQualifier(spEntityId);
        }
        return issuer;
    }

    protected AuthnContextComparisonTypeEnumeration getComparisonTypeEnumFromString(String comparisonType) {
        if ("exact".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.EXACT;
        }
        if ("minimum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MINIMUM;
        }
        if ("maximum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MAXIMUM;
        }
        if ("better".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.BETTER;
        }
        return null;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

