/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ServiceProviderMetadataResolver
implements SAML2MetadataResolver {
    protected static final Logger logger = LoggerFactory.getLogger(SAML2ServiceProviderMetadataResolver.class);
    protected final SAML2Configuration configuration;
    private MetadataResolver metadataResolver;

    public SAML2ServiceProviderMetadataResolver(SAML2Configuration configuration) {
        this.configuration = configuration;
        this.metadataResolver = this.prepareServiceProviderMetadata();
    }

    public void destroy() {
        if (this.metadataResolver instanceof FilesystemMetadataResolver) {
            ((FilesystemMetadataResolver)this.metadataResolver).destroy();
            this.metadataResolver = null;
        }
    }

    protected MetadataResolver prepareServiceProviderMetadata() {
        try {
            SAML2MetadataGenerator metadataGenerator = this.configuration.toMetadataGenerator();
            EntityDescriptor entity = metadataGenerator.buildEntityDescriptor();
            String metadata = metadataGenerator.getMetadata(entity);
            metadataGenerator.storeMetadata(metadata, this.configuration.getServiceProviderMetadataResource(), this.configuration.isForceServiceProviderMetadataGeneration());
            return metadataGenerator.buildMetadataResolver(this.configuration.getServiceProviderMetadataResource());
        }
        catch (Exception e) {
            throw new SAMLException("Unable to generate metadata for service provider", e);
        }
    }

    @Override
    public final MetadataResolver resolve() {
        return this.metadataResolver;
    }

    @Override
    public final String getEntityId() {
        return this.configuration.getServiceProviderEntityId();
    }

    @Override
    public String getMetadata() {
        try {
            SAML2MetadataGenerator metadataGenerator = this.configuration.toMetadataGenerator();
            EntityDescriptor entity = metadataGenerator.buildEntityDescriptor();
            return metadataGenerator.getMetadata(entity);
        }
        catch (Exception e) {
            throw new SAMLException("Unable to fetch metadata", e);
        }
    }

    @Override
    public XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.getEntityId())}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Unable to resolve metadata", e);
        }
    }
}

