/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2IdentityProviderMetadataResolver
implements SAML2MetadataResolver {
    private static final long NO_LAST_MODIFIED = -1L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Resource idpMetadataResource;
    private String idpEntityId;
    private DOMMetadataResolver idpMetadataProvider;
    private long lastModified = -1L;
    private ReentrantLock lock = new ReentrantLock();

    public SAML2IdentityProviderMetadataResolver(SAML2Configuration configuration) {
        this(configuration.getIdentityProviderMetadataResource(), configuration.getIdentityProviderEntityId());
    }

    public SAML2IdentityProviderMetadataResolver(Resource idpMetadataResource, @Nullable String idpEntityId) {
        CommonHelper.assertNotNull((String)"identityProviderMetadataResource", (Object)idpMetadataResource);
        this.idpMetadataResource = idpMetadataResource;
        this.idpEntityId = idpEntityId;
    }

    public void init() {
        this.idpMetadataProvider = this.buildMetadata();
        if (this.idpMetadataResource instanceof FileSystemResource) {
            this.hasChanged();
        }
    }

    @Override
    public final MetadataResolver resolve() {
        if (this.idpMetadataResource instanceof FileSystemResource && this.lock.tryLock()) {
            try {
                if (this.hasChanged()) {
                    this.idpMetadataProvider = this.buildMetadata();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.idpMetadataProvider;
    }

    protected boolean hasChanged() {
        long newLastModified;
        try {
            newLastModified = this.idpMetadataResource.lastModified();
        }
        catch (IOException e) {
            newLastModified = -1L;
        }
        boolean hasChanged = this.lastModified != newLastModified;
        this.logger.debug("lastModified: {} / newLastModified: {} -> hasChanged: {}", new Object[]{this.lastModified, newLastModified, hasChanged});
        this.lastModified = newLastModified;
        return hasChanged;
    }

    protected DOMMetadataResolver buildMetadata() {
        try {
            DOMMetadataResolver resolver;
            try (InputStream in = this.idpMetadataResource.getInputStream();){
                Document inCommonMDDoc = Configuration.getParserPool().parse(in);
                Element metadataRoot = inCommonMDDoc.getDocumentElement();
                resolver = new DOMMetadataResolver(metadataRoot);
                resolver.setIndexes(Collections.singleton(new RoleMetadataIndex()));
                resolver.setParserPool(Configuration.getParserPool());
                resolver.setFailFastInitialization(true);
                resolver.setRequireValidMetadata(true);
                resolver.setId(resolver.getClass().getCanonicalName());
                resolver.initialize();
            }
            catch (FileNotFoundException e) {
                throw new TechnicalException("Error loading idp Metadata");
            }
            if (this.idpEntityId == null) {
                for (EntityDescriptor entityDescriptor : resolver) {
                    if (this.idpEntityId != null) continue;
                    this.idpEntityId = entityDescriptor.getEntityID();
                }
            }
            if (this.idpEntityId == null) {
                throw new SAMLException("No idp entityId found");
            }
            return resolver;
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
        catch (XMLParserException e) {
            throw new TechnicalException("Error parsing idp Metadata", (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Error getting idp Metadata resource", (Throwable)e);
        }
    }

    @Override
    public String getEntityId() {
        XMLObject md = this.getEntityDescriptorElement();
        if (md instanceof EntitiesDescriptor) {
            return ((EntityDescriptor)((EntitiesDescriptor)md).getEntityDescriptors().get(0)).getEntityID();
        }
        if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SAMLException("No idp entityId found");
    }

    @Override
    public String getMetadata() {
        if (this.getEntityDescriptorElement() != null) {
            return Configuration.serializeSamlObject(this.getEntityDescriptorElement()).toString();
        }
        throw new TechnicalException("Metadata cannot be retrieved because entity descriptor is null");
    }

    @Override
    public final XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.idpEntityId)}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }
}

