/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2MessageSender;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jHTTPPostSimpleSignEncoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class AbstractSAML2MessageSender<T extends SAMLObject>
implements SAML2MessageSender<T> {
    protected final Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected final String destinationBindingType;
    protected final boolean signErrorResponses;
    protected final boolean isRequestSigned;

    public AbstractSAML2MessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean signErrorResponses, boolean isRequestSigned) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
        this.destinationBindingType = destinationBindingType;
        this.signErrorResponses = signErrorResponses;
        this.isRequestSigned = isRequestSigned;
    }

    @Override
    public void sendMessage(SAML2MessageContext context, T request, Object relayState) {
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        IDPSSODescriptor idpssoDescriptor = context.getIDPSSODescriptor();
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        MessageEncoder encoder = this.getMessageEncoder(spDescriptor, idpssoDescriptor, context);
        SAML2MessageContext outboundContext = new SAML2MessageContext();
        outboundContext.setMessageContext(context.getMessageContext());
        outboundContext.getProfileRequestContext().setProfileId(outboundContext.getProfileRequestContext().getProfileId());
        outboundContext.getProfileRequestContext().setInboundMessageContext(context.getProfileRequestContext().getInboundMessageContext());
        outboundContext.getProfileRequestContext().setOutboundMessageContext(context.getProfileRequestContext().getOutboundMessageContext());
        outboundContext.getMessageContext().setMessage(request);
        outboundContext.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        outboundContext.getSAMLPeerEndpointContext().setEndpoint(this.getEndpoint(outboundContext));
        outboundContext.getSAMLPeerEntityContext().setRole(outboundContext.getSAMLPeerEntityContext().getRole());
        outboundContext.getSAMLPeerEntityContext().setEntityId(outboundContext.getSAMLPeerEntityContext().getEntityId());
        outboundContext.getSAMLProtocolContext().setProtocol(outboundContext.getSAMLProtocolContext().getProtocol());
        outboundContext.getSecurityParametersContext().setSignatureSigningParameters(this.signatureSigningParametersProvider.build((SSODescriptor)spDescriptor));
        if (relayState != null) {
            outboundContext.getSAMLBindingContext().setRelayState(relayState.toString());
        }
        try {
            MessageContext messageContext = outboundContext.getMessageContext();
            this.invokeOutboundMessageHandlers(spDescriptor, idpssoDescriptor, messageContext);
            encoder.setMessageContext(messageContext);
            encoder.initialize();
            encoder.prepareContext();
            encoder.encode();
            this.storeMessage(context, request);
            this.logProtocolMessage((XMLObject)request);
        }
        catch (MarshallingException e) {
            throw new SAMLException("Error marshalling saml message", e);
        }
        catch (MessageEncodingException e) {
            throw new SAMLException("Error encoding saml message", e);
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing saml encoder", e);
        }
    }

    protected void storeMessage(SAML2MessageContext context, T request) {
        SAMLMessageStore messageStorage = context.getSAMLMessageStore();
        if (messageStorage != null) {
            if (request instanceof RequestAbstractType) {
                messageStorage.set(((RequestAbstractType)request).getID(), request);
            } else if (request instanceof StatusResponseType) {
                messageStorage.set(((StatusResponseType)request).getID(), request);
            }
        }
    }

    protected void logProtocolMessage(XMLObject object) throws MarshallingException {
        if (this.protocolMessageLog.isDebugEnabled()) {
            String requestXml = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)object));
            this.protocolMessageLog.debug(requestXml);
        }
    }

    protected abstract Endpoint getEndpoint(SAML2MessageContext var1);

    protected void invokeOutboundMessageHandlers(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, MessageContext messageContext) {
        try {
            EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
            handlerEnd.initialize();
            handlerEnd.invoke(messageContext);
            SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
            handlerDest.initialize();
            handlerDest.invoke(messageContext);
            if (!this.destinationBindingType.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && this.mustSignRequest(spDescriptor, idpssoDescriptor)) {
                this.logger.debug("Signing SAML2 outbound context...");
                SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
                handler.setSignErrorResponses(this.signErrorResponses);
                handler.invoke(messageContext);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected boolean mustSignRequest(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor) {
        return this.isRequestSigned;
    }

    private MessageEncoder getMessageEncoder(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext ctx) {
        Pac4jSAMLResponse adapter = ctx.getProfileRequestContextOutboundMessageTransportResponse();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostEncoder encoder = new Pac4jHTTPPostEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostSimpleSignEncoder encoder = new Pac4jHTTPPostSimpleSignEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            return new Pac4jHTTPRedirectDeflateEncoder(adapter, this.mustSignRequest(spDescriptor, idpssoDescriptor));
        }
        throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
    }
}

