/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import java.io.ByteArrayInputStream;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.impl.SAMLSOAPDecoderBodyHandler;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.transport.AbstractPac4jDecoder;

public class Pac4jHTTPPostDecoder
extends AbstractPac4jDecoder {
    public Pac4jHTTPPostDecoder(WebContext context) {
        super(context);
    }

    protected void doDecode() throws MessageDecodingException {
        SAML2MessageContext messageContext = new SAML2MessageContext();
        if (WebContextHelper.isPost((WebContext)this.context)) {
            String relayState = this.context.getRequestParameter("RelayState").orElse(null);
            this.logger.debug("Decoded SAML relay state of: {}", (Object)relayState);
            SAMLBindingSupport.setRelayState((MessageContext)messageContext.getMessageContext(), (String)relayState);
            byte[] base64DecodedMessage = this.getBase64DecodedMessage();
            XMLObject xmlObject = this.unmarshallMessage(new ByteArrayInputStream(base64DecodedMessage));
            if (xmlObject instanceof Envelope) {
                Envelope soapMessage = (Envelope)xmlObject;
                messageContext.getSOAP11Context().setEnvelope(soapMessage);
                try {
                    new SAMLSOAPDecoderBodyHandler().invoke(messageContext.getMessageContext());
                }
                catch (MessageHandlerException e) {
                    throw new MessageDecodingException("Cannot decode SOAP envelope", (Exception)((Object)e));
                }
            } else {
                SAMLObject inboundMessage = (SAMLObject)xmlObject;
                messageContext.getMessageContext().setMessage((Object)inboundMessage);
            }
        } else {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        this.logger.debug("Decoded SAML message");
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext.getMessageContext());
    }

    @Override
    public String getBindingURI(SAML2MessageContext messageContext) {
        if (messageContext.getSOAP11Context().getEnvelope() != null) {
            return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
        }
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }
}

