/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.ext.saml2mdreqinit.RequestInitiator;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.metadata.DefaultSAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataContactPerson;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataUIInfo;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSAML2MetadataGenerator
implements SAML2MetadataGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(BaseSAML2MetadataGenerator.class);
    protected final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    protected final MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
    protected final AlgorithmRegistry globalAlgorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    protected CredentialProvider credentialProvider;
    protected String entityId;
    protected String assertionConsumerServiceUrl;
    protected String responseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    protected String singleLogoutServiceUrl;
    protected boolean authnRequestSigned = false;
    protected boolean wantAssertionSigned = true;
    protected boolean signMetadata = false;
    protected int defaultACSIndex = 0;
    protected String requestInitiatorLocation = null;
    protected String nameIdPolicyFormat = null;
    protected List<SAML2ServiceProviderRequestedAttribute> requestedAttributes = new ArrayList<SAML2ServiceProviderRequestedAttribute>();
    protected SignatureSigningConfiguration defaultSignatureSigningConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
    protected List<String> blackListedSignatureSigningAlgorithms = null;
    protected List<String> signatureAlgorithms = null;
    protected List<String> signatureReferenceDigestMethods = null;
    private List<SAML2MetadataContactPerson> contactPersons = new ArrayList<SAML2MetadataContactPerson>();
    private List<SAML2MetadataUIInfo> metadataUIInfos = new ArrayList<SAML2MetadataUIInfo>();
    private List<String> supportedProtocols = new ArrayList<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol"));
    private SAML2MetadataSigner metadataSigner;

    @Override
    public MetadataResolver buildMetadataResolver() throws Exception {
        AbstractMetadataResolver resolver = this.createMetadataResolver();
        if (resolver == null) {
            EntityDescriptor md = this.buildEntityDescriptor();
            Element entityDescriptorElement = this.marshallerFactory.getMarshaller((XMLObject)md).marshall((XMLObject)md);
            resolver = new DOMMetadataResolver(entityDescriptorElement);
        }
        resolver.setRequireValidMetadata(true);
        resolver.setFailFastInitialization(true);
        resolver.setId(resolver.getClass().getCanonicalName());
        resolver.setParserPool(Configuration.getParserPool());
        resolver.initialize();
        return resolver;
    }

    protected abstract AbstractMetadataResolver createMetadataResolver() throws Exception;

    @Override
    public String getMetadata(EntityDescriptor entityDescriptor) throws Exception {
        Element entityDescriptorElement = this.marshallerFactory.getMarshaller(EntityDescriptor.DEFAULT_ELEMENT_NAME).marshall((XMLObject)entityDescriptor);
        return SerializeSupport.nodeToString((Node)entityDescriptorElement);
    }

    @Override
    public EntityDescriptor buildEntityDescriptor() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor descriptor = (EntityDescriptor)Objects.requireNonNull(builder).buildObject();
        descriptor.setEntityID(this.entityId);
        descriptor.setValidUntil(ZonedDateTime.now(ZoneOffset.UTC).plusYears(20L).toInstant());
        descriptor.setID(SAML2Utils.generateID());
        descriptor.setExtensions(this.generateMetadataExtensions());
        descriptor.getRoleDescriptors().add(this.buildSPSSODescriptor());
        if (this.signMetadata) {
            this.signMetadata(descriptor);
        }
        return descriptor;
    }

    protected void signMetadata(EntityDescriptor descriptor) {
        if (this.metadataSigner == null) {
            this.metadataSigner = new DefaultSAML2MetadataSigner(this.credentialProvider, this.getSignatureAlgorithms().get(0), this.getSignatureReferenceDigestMethods().get(0));
        }
        this.metadataSigner.sign((SignableXMLObject)descriptor);
    }

    protected Extensions generateMetadataExtensions() {
        SAMLObjectBuilder builderExt = (SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        Extensions extensions = (Extensions)builderExt.buildObject();
        extensions.getNamespaceManager().registerAttributeName(SigningMethod.TYPE_NAME);
        extensions.getNamespaceManager().registerAttributeName(DigestMethod.TYPE_NAME);
        SAMLObjectBuilder signingMethodBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SigningMethod.DEFAULT_ELEMENT_NAME);
        List<String> filteredSignatureAlgorithms = this.filterSignatureAlgorithms(this.getSignatureAlgorithms());
        filteredSignatureAlgorithms.forEach(signingMethod -> {
            SigningMethod method = (SigningMethod)Objects.requireNonNull(signingMethodBuilder).buildObject();
            method.setAlgorithm(signingMethod);
            extensions.getUnknownXMLObjects().add(method);
        });
        SAMLObjectBuilder digestMethodBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(DigestMethod.DEFAULT_ELEMENT_NAME);
        List<String> filteredSignatureReferenceDigestMethods = this.filterSignatureAlgorithms(this.getSignatureReferenceDigestMethods());
        filteredSignatureReferenceDigestMethods.forEach(digestMethod -> {
            DigestMethod method = (DigestMethod)Objects.requireNonNull(digestMethodBuilder).buildObject();
            method.setAlgorithm(digestMethod);
            extensions.getUnknownXMLObjects().add(method);
        });
        return extensions;
    }

    protected SPSSODescriptor buildSPSSODescriptor() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        SPSSODescriptor spDescriptor = (SPSSODescriptor)Objects.requireNonNull(builder).buildObject();
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(this.authnRequestSigned));
        spDescriptor.setWantAssertionsSigned(Boolean.valueOf(this.wantAssertionSigned));
        this.supportedProtocols.forEach(arg_0 -> ((SPSSODescriptor)spDescriptor).addSupportedProtocol(arg_0));
        SAMLObjectBuilder builderExt = (SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        Extensions extensions = (Extensions)Objects.requireNonNull(builderExt).buildObject();
        extensions.getNamespaceManager().registerAttributeName(RequestInitiator.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder builderReq = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestInitiator.DEFAULT_ELEMENT_NAME);
        RequestInitiator requestInitiator = (RequestInitiator)Objects.requireNonNull(builderReq).buildObject();
        requestInitiator.setLocation(this.requestInitiatorLocation);
        requestInitiator.setBinding(RequestInitiator.DEFAULT_ELEMENT_NAME.getNamespaceURI());
        extensions.getUnknownXMLObjects().add(requestInitiator);
        spDescriptor.setExtensions(extensions);
        spDescriptor.getNameIDFormats().addAll(this.buildNameIDFormat());
        int index = 0;
        spDescriptor.getAssertionConsumerServices().add(this.getAssertionConsumerService(this.responseBindingType, index++, this.defaultACSIndex == index));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:SOAP"));
        if (this.credentialProvider != null) {
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.SIGNING, this.credentialProvider.getKeyInfo()));
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.ENCRYPTION, this.credentialProvider.getKeyInfo()));
        }
        if (!this.requestedAttributes.isEmpty()) {
            SAMLObjectBuilder attrServiceBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
            AttributeConsumingService attributeService = (AttributeConsumingService)attrServiceBuilder.buildObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
            for (SAML2ServiceProviderRequestedAttribute attr : this.requestedAttributes) {
                SAMLObjectBuilder attrBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestedAttribute.DEFAULT_ELEMENT_NAME);
                RequestedAttribute requestAttribute = (RequestedAttribute)attrBuilder.buildObject(RequestedAttribute.DEFAULT_ELEMENT_NAME);
                requestAttribute.setIsRequired(Boolean.valueOf(attr.isRequired()));
                requestAttribute.setName(attr.getName());
                requestAttribute.setFriendlyName(attr.getFriendlyName());
                requestAttribute.setNameFormat(attr.getNameFormat());
                attributeService.getRequestedAttributes().add(requestAttribute);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attr.getServiceName())) continue;
                SAMLObjectBuilder serviceBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(ServiceName.DEFAULT_ELEMENT_NAME);
                ServiceName serviceName = (ServiceName)Objects.requireNonNull(serviceBuilder).buildObject();
                serviceName.setValue(attr.getServiceName());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attr.getServiceLang())) {
                    serviceName.setXMLLang(attr.getServiceLang());
                }
                attributeService.getNames().add(serviceName);
            }
            spDescriptor.getAttributeConsumingServices().add(attributeService);
        }
        SAMLObjectBuilder contactPersonBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(ContactPerson.DEFAULT_ELEMENT_NAME);
        this.contactPersons.forEach(p -> {
            ContactPerson person = (ContactPerson)Objects.requireNonNull(contactPersonBuilder).buildObject();
            switch (p.getType().toLowerCase()) {
                case "technical": {
                    person.setType(ContactPersonTypeEnumeration.TECHNICAL);
                    break;
                }
                case "administrative": {
                    person.setType(ContactPersonTypeEnumeration.ADMINISTRATIVE);
                    break;
                }
                case "billing": {
                    person.setType(ContactPersonTypeEnumeration.BILLING);
                    break;
                }
                case "support": {
                    person.setType(ContactPersonTypeEnumeration.SUPPORT);
                    break;
                }
                default: {
                    person.setType(ContactPersonTypeEnumeration.OTHER);
                }
            }
            if (CommonHelper.isNotBlank((String)p.getSurname())) {
                SAMLObjectBuilder surnameBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SurName.DEFAULT_ELEMENT_NAME);
                SurName surName = (SurName)Objects.requireNonNull(surnameBuilder).buildObject();
                surName.setValue(p.getSurname());
                person.setSurName(surName);
            }
            if (CommonHelper.isNotBlank((String)p.getGivenName())) {
                SAMLObjectBuilder givenNameBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(GivenName.DEFAULT_ELEMENT_NAME);
                GivenName givenName = (GivenName)Objects.requireNonNull(givenNameBuilder).buildObject();
                givenName.setValue(p.getGivenName());
                person.setGivenName(givenName);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)p.getCompanyName())) {
                SAMLObjectBuilder companyBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Company.DEFAULT_ELEMENT_NAME);
                Company company = (Company)Objects.requireNonNull(companyBuilder).buildObject();
                company.setValue(p.getCompanyName());
                person.setCompany(company);
            }
            if (!p.getEmailAddresses().isEmpty()) {
                SAMLObjectBuilder emailBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(EmailAddress.DEFAULT_ELEMENT_NAME);
                p.getEmailAddresses().forEach(email -> {
                    EmailAddress emailAddr = (EmailAddress)Objects.requireNonNull(emailBuilder).buildObject();
                    emailAddr.setURI(email);
                    person.getEmailAddresses().add(emailAddr);
                });
            }
            if (!p.getTelephoneNumbers().isEmpty()) {
                SAMLObjectBuilder phoneBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(TelephoneNumber.DEFAULT_ELEMENT_NAME);
                p.getTelephoneNumbers().forEach(ph -> {
                    TelephoneNumber phone = (TelephoneNumber)Objects.requireNonNull(phoneBuilder).buildObject();
                    phone.setValue(ph);
                    person.getTelephoneNumbers().add(phone);
                });
            }
            spDescriptor.getContactPersons().add(person);
        });
        if (!this.metadataUIInfos.isEmpty()) {
            SAMLObjectBuilder uiInfoBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(UIInfo.DEFAULT_ELEMENT_NAME);
            UIInfo uiInfo = (UIInfo)uiInfoBuilder.buildObject();
            this.metadataUIInfos.forEach(info -> {
                info.getDescriptions().forEach(desc -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Description.DEFAULT_ELEMENT_NAME);
                    Description description = (Description)uiBuilder.buildObject();
                    description.setValue(desc);
                    uiInfo.getDescriptions().add(description);
                });
                info.getDisplayNames().forEach(name -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(DisplayName.DEFAULT_ELEMENT_NAME);
                    DisplayName displayName = (DisplayName)uiBuilder.buildObject();
                    displayName.setValue(name);
                    uiInfo.getDisplayNames().add(displayName);
                });
                info.getInformationUrls().forEach(url -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(InformationURL.DEFAULT_ELEMENT_NAME);
                    InformationURL informationURL = (InformationURL)uiBuilder.buildObject();
                    informationURL.setURI(url);
                    uiInfo.getInformationURLs().add(informationURL);
                });
                info.getPrivacyUrls().forEach(privacy -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(PrivacyStatementURL.DEFAULT_ELEMENT_NAME);
                    PrivacyStatementURL privacyStatementURL = (PrivacyStatementURL)uiBuilder.buildObject();
                    privacyStatementURL.setURI(privacy);
                    uiInfo.getPrivacyStatementURLs().add(privacyStatementURL);
                });
                info.getKeywords().forEach(kword -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Keywords.DEFAULT_ELEMENT_NAME);
                    Keywords keyword = (Keywords)uiBuilder.buildObject();
                    keyword.setKeywords(new ArrayList(StringUtils.commaDelimitedListToSet((String)kword)));
                    uiInfo.getKeywords().add(keyword);
                });
                info.getLogos().forEach(lg -> {
                    SAMLObjectBuilder uiBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Logo.DEFAULT_ELEMENT_NAME);
                    Logo logo = (Logo)uiBuilder.buildObject();
                    logo.setURI(lg.getUrl());
                    logo.setHeight(Integer.valueOf(lg.getHeight()));
                    logo.setWidth(Integer.valueOf(lg.getWidth()));
                    uiInfo.getLogos().add(logo);
                });
            });
            extensions.getUnknownXMLObjects().add(uiInfo);
        }
        return spDescriptor;
    }

    protected Collection<NameIDFormat> buildNameIDFormat() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME);
        ArrayList<NameIDFormat> formats = new ArrayList<NameIDFormat>();
        if (this.nameIdPolicyFormat != null) {
            NameIDFormat nameID = (NameIDFormat)Objects.requireNonNull(builder).buildObject();
            nameID.setURI(this.nameIdPolicyFormat);
            formats.add(nameID);
        } else {
            NameIDFormat transientNameID = (NameIDFormat)Objects.requireNonNull(builder).buildObject();
            transientNameID.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            formats.add(transientNameID);
            NameIDFormat persistentNameID = (NameIDFormat)builder.buildObject();
            persistentNameID.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            formats.add(persistentNameID);
            NameIDFormat emailNameID = (NameIDFormat)builder.buildObject();
            emailNameID.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            formats.add(emailNameID);
            NameIDFormat unspecNameID = (NameIDFormat)builder.buildObject();
            unspecNameID.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            formats.add(unspecNameID);
        }
        return formats;
    }

    protected AssertionConsumerService getAssertionConsumerService(String binding, int index, boolean isDefault) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        AssertionConsumerService consumer = (AssertionConsumerService)Objects.requireNonNull(builder).buildObject();
        consumer.setLocation(this.assertionConsumerServiceUrl);
        consumer.setBinding(binding);
        if (isDefault) {
            consumer.setIsDefault(Boolean.valueOf(true));
        }
        consumer.setIndex(Integer.valueOf(index));
        return consumer;
    }

    protected SingleLogoutService getSingleLogoutService(String binding) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        SingleLogoutService logoutService = (SingleLogoutService)Objects.requireNonNull(builder).buildObject();
        logoutService.setLocation(this.singleLogoutServiceUrl);
        logoutService.setBinding(binding);
        return logoutService;
    }

    protected KeyDescriptor getKeyDescriptor(UsageType type, KeyInfo key) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyDescriptor descriptor = (KeyDescriptor)Objects.requireNonNull(builder).buildObject();
        descriptor.setUse(type);
        descriptor.setKeyInfo(key);
        return descriptor;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public final void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public final void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public final void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public boolean isWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    public void setWantAssertionSigned(boolean wantAssertionSigned) {
        this.wantAssertionSigned = wantAssertionSigned;
    }

    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    public int getDefaultACSIndex() {
        return this.defaultACSIndex;
    }

    public void setDefaultACSIndex(int defaultACSIndex) {
        this.defaultACSIndex = defaultACSIndex;
    }

    public final void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public void setResponseBindingType(String responseBindingType) {
        this.responseBindingType = responseBindingType;
    }

    public final void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.singleLogoutServiceUrl = singleLogoutServiceUrl;
    }

    public final void setRequestInitiatorLocation(String requestInitiatorLocation) {
        this.requestInitiatorLocation = requestInitiatorLocation;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public List<SAML2ServiceProviderRequestedAttribute> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public void setRequestedAttributes(List<SAML2ServiceProviderRequestedAttribute> requestedAttributes) {
        this.requestedAttributes = requestedAttributes;
    }

    public List<String> getBlackListedSignatureSigningAlgorithms() {
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(this.defaultSignatureSigningConfiguration.getExcludedAlgorithms());
        }
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(List<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new ArrayList<String>(this.defaultSignatureSigningConfiguration.getSignatureAlgorithms());
        }
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = this.defaultSignatureSigningConfiguration.getSignatureReferenceDigestMethods();
        }
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public List<SAML2MetadataContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public void setContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
    }

    public List<SAML2MetadataUIInfo> getMetadataUIInfos() {
        return this.metadataUIInfos;
    }

    public void setMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        this.metadataUIInfos = metadataUIInfos;
    }

    private List<String> filterForRuntimeSupportedAlgorithms(List<String> algorithms) {
        ArrayList<String> filteredAlgorithms = new ArrayList<String>(algorithms);
        return filteredAlgorithms.stream().filter(uri -> Objects.requireNonNull(this.globalAlgorithmRegistry).isRuntimeSupported(uri)).collect(Collectors.toList());
    }

    private List<String> filterSignatureAlgorithms(List<String> algorithms) {
        List<String> filteredAlgorithms = this.filterForRuntimeSupportedAlgorithms(algorithms);
        if (this.blackListedSignatureSigningAlgorithms != null) {
            filteredAlgorithms.removeAll(this.blackListedSignatureSigningAlgorithms);
        }
        return filteredAlgorithms;
    }

    public SAML2MetadataSigner getMetadataSigner() {
        return this.metadataSigner;
    }

    public void setMetadataSigner(SAML2MetadataSigner metadataSigner) {
        this.metadataSigner = metadataSigner;
    }
}

