/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.util.Configuration;
import org.w3c.dom.Element;

public class SAML2MongoMetadataGenerator
extends BaseSAML2MetadataGenerator {
    private final MongoClient mongoClient;
    private final String entityId;
    private String metadataDatabase = "saml2";
    private String metadataCollection = "metadata";

    public SAML2MongoMetadataGenerator(MongoClient mongoClient, String entityId) {
        this.mongoClient = mongoClient;
        this.entityId = entityId;
    }

    @Override
    public AbstractMetadataResolver createMetadataResolver() throws Exception {
        FindIterable documents = Objects.requireNonNull(this.getCollection().find(this.buildMetadataDocumentFilter(this.entityId)));
        Document foundDoc = (Document)documents.first();
        if (foundDoc != null) {
            String metadata = foundDoc.getString((Object)"metadata");
            try (ByteArrayInputStream is = new ByteArrayInputStream(metadata.getBytes(StandardCharsets.UTF_8));){
                org.w3c.dom.Document document = Configuration.getParserPool().parse((InputStream)is);
                Element root = document.getDocumentElement();
                DOMMetadataResolver dOMMetadataResolver = new DOMMetadataResolver(root);
                return dOMMetadataResolver;
            }
        }
        throw new SAMLException("Unable to locate metadata document ");
    }

    protected Bson buildMetadataDocumentFilter(String entityId) {
        return Filters.eq((String)"entityId", (Object)entityId);
    }

    @Override
    public boolean storeMetadata(String metadata, boolean force) {
        if (CommonHelper.isBlank((String)metadata)) {
            logger.info("No metadata is provided");
            return false;
        }
        String metadataToUse = this.isSignMetadata() ? this.getMetadataSigner().sign(metadata) : metadata;
        CommonHelper.assertNotBlank((String)"metadata", (String)metadataToUse);
        String metadataEntityId = Configuration.deserializeSamlObject(metadataToUse).map(EntityDescriptor.class::cast).map(EntityDescriptor::getEntityID).orElseThrow();
        if (!metadataEntityId.equals(this.entityId)) {
            throw new SAMLException("Entity id from metadata " + metadataEntityId + " does not match supplied entity id " + this.entityId);
        }
        Bson filter = this.buildMetadataDocumentFilter(metadataEntityId);
        Document foundDoc = (Document)this.getCollection().find(filter).first();
        if (foundDoc == null) {
            Document doc = new Document();
            doc.put("metadata", (Object)metadataToUse);
            doc.put("entityId", (Object)metadataEntityId);
            return this.getCollection().insertOne((Object)doc).getInsertedId() != null;
        }
        foundDoc.put("metadata", (Object)metadataToUse);
        UpdateResult updateResult = this.getCollection().updateOne(filter, (Bson)new Document("$set", (Object)foundDoc));
        return updateResult.getMatchedCount() == 1L;
    }

    protected MongoCollection<Document> getCollection() {
        MongoDatabase db = this.mongoClient.getDatabase(this.metadataDatabase);
        return Objects.requireNonNull(db.getCollection(this.metadataCollection));
    }

    public String getMetadataDatabase() {
        return this.metadataDatabase;
    }

    public void setMetadataDatabase(String metadataDatabase) {
        this.metadataDatabase = metadataDatabase;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }
}

