/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import net.shibboleth.shared.net.URIComparator;
import net.shibboleth.shared.net.impl.BasicURLComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2FileSystemMetadataGenerator;
import org.pac4j.saml.metadata.SAML2HttpUrlMetadataGenerator;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataContactPerson;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataUIInfo;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.metadata.keystore.SAML2FileSystemKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2HttpUrlKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.pac4j.saml.profile.converter.SimpleSAML2AttributeConverter;
import org.pac4j.saml.sso.impl.SAML2ScopingIdentityProvider;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.pac4j.saml.util.SAML2HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SAML2Configuration
extends BaseClientConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2Configuration.class);
    protected static final String RESOURCE_PREFIX = "resource:";
    protected static final String CLASSPATH_PREFIX = "classpath:";
    protected static final String FILE_PREFIX = "file:";
    protected static final String DEFAULT_PROVIDER_NAME = "pac4j-saml";
    private final List<SAML2ScopingIdentityProvider> scopingIdentityProviders = new ArrayList<SAML2ScopingIdentityProvider>();
    private final List<SAML2ServiceProviderRequestedAttribute> requestedServiceProviderAttributes = new ArrayList<SAML2ServiceProviderRequestedAttribute>();
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private SAML2MetadataSigner metadataSigner;
    private String singleSignOutServiceUrl;
    private String nameIdAttribute;
    private String callbackUrl;
    private String requestInitiatorUrl;
    private String assertionConsumerServiceUrl;
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private String certificateNameToAppend;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private long maximumAuthenticationLifetime = 3600L;
    private long acceptedSkew = 300L;
    private boolean forceAuth = false;
    private boolean passive = false;
    private String comparisonType = null;
    private boolean isPartialLogoutTreatedAsSuccess = true;
    private String authnRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String responseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutResponseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private List<String> authnContextClassRefs = new ArrayList<String>();
    private String nameIdPolicyFormat = null;
    private boolean useNameQualifier = false;
    private boolean signMetadata;
    private Resource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private boolean forceKeystoreGeneration;
    private SAMLMessageStoreFactory samlMessageStoreFactory = new EmptyStoreFactory();
    private SAML2KeystoreGenerator keystoreGenerator;
    private SAML2MetadataGenerator metadataGenerator;
    private boolean authnRequestSigned;
    private boolean spLogoutRequestSigned;
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = false;
    private boolean wantsResponsesSigned = false;
    private boolean allSignatureValidationDisabled = false;
    private boolean responseDestinationAttributeMandatory = true;
    private String keyStoreAlias;
    private String keyStoreType;
    private int assertionConsumerServiceIndex = -1;
    private int attributeConsumingServiceIndex = -1;
    private String providerName;
    private Supplier<List<XSAny>> authnRequestExtensions;
    private String attributeAsId;
    private Map<String, String> mappedAttributes = new LinkedHashMap<String, String>();
    private URIComparator uriComparator = new BasicURLComparator();
    private LogoutHandler logoutHandler;
    private String postLogoutURL;
    private Period certificateExpirationPeriod = Period.ofYears(20);
    private String certificateSignatureAlg = "SHA1WithRSA";
    private int privateKeySize = 2048;
    private List<SAML2MetadataContactPerson> contactPersons = new ArrayList<SAML2MetadataContactPerson>();
    private List<SAML2MetadataUIInfo> metadataUIInfos = new ArrayList<SAML2MetadataUIInfo>();
    private String issuerFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
    private HttpClient httpClient;
    private AttributeConverter samlAttributeConverter = new SimpleSAML2AttributeConverter();
    private Boolean nameIdPolicyAllowCreate = Boolean.TRUE;
    private List<String> supportedProtocols = new ArrayList<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol"));
    private SAML2MetadataResolver identityProviderMetadataResolver;
    private int identityProviderMetadataConnectTimeout = 2500;
    private int identityProviderMetadataReadTimeout = 2500;

    public SAML2Configuration() {
    }

    public SAML2Configuration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, SAML2Configuration.mapPathToResource(keystorePath), keystorePassword, privateKeyPassword, SAML2Configuration.mapPathToResource(identityProviderMetadataPath), null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, null, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keyStoreAlias, keyStoreType, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    protected SAML2Configuration(String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId, String providerName, Supplier<List<XSAny>> authnRequestExtensions, String attributeAsId) {
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.providerName = providerName;
        this.authnRequestExtensions = authnRequestExtensions;
        this.attributeAsId = attributeAsId;
    }

    protected static UrlResource newUrlResource(String url) {
        try {
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    private static Resource mapPathToResource(String path) {
        CommonHelper.assertNotBlank((String)"path", (String)path);
        try {
            if (path.startsWith(RESOURCE_PREFIX)) {
                return new ClassPathResource(path.substring(RESOURCE_PREFIX.length()));
            }
            if (path.startsWith(CLASSPATH_PREFIX)) {
                return new ClassPathResource(path.substring(CLASSPATH_PREFIX.length()));
            }
            if (path.startsWith("http") || path.startsWith("https")) {
                return new UrlResource(new URL(path));
            }
            if (path.startsWith(FILE_PREFIX)) {
                return new FileSystemResource(path.substring(FILE_PREFIX.length()));
            }
            return new FileSystemResource(path);
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        try {
            if (CommonHelper.isBlank((String)this.getServiceProviderEntityId())) {
                URL url = new URL(callbackUrl);
                if (url.getQuery() != null) {
                    this.setServiceProviderEntityId(url.toString().replace("?" + url.getQuery(), ""));
                } else {
                    this.setServiceProviderEntityId(url.toString());
                }
            }
            LOGGER.info("Using service provider entity ID {}", (Object)this.getServiceProviderEntityId());
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected void internalInit(boolean forceReinit) {
        SAML2KeystoreGenerator keystoreGenerator = this.getKeystoreGenerator();
        if (keystoreGenerator.shouldGenerate()) {
            LOGGER.warn("Generating keystore one for/via: {}", (Object)this.keystoreResource);
            keystoreGenerator.generate();
        }
        if (this.logoutHandler == null) {
            this.logoutHandler = new DefaultLogoutHandler();
        }
        this.initSignatureSigningConfiguration();
    }

    public SAML2KeystoreGenerator getKeystoreGenerator() {
        if (this.keystoreGenerator == null) {
            if (this.keystoreResource instanceof UrlResource) {
                return new SAML2HttpUrlKeystoreGenerator(this);
            }
            return new SAML2FileSystemKeystoreGenerator(this);
        }
        return this.keystoreGenerator;
    }

    public void setIdentityProviderMetadataResourceFilepath(String path) {
        this.identityProviderMetadataResource = new FileSystemResource(path);
    }

    public void setIdentityProviderMetadataResourceClasspath(String path) {
        this.identityProviderMetadataResource = new ClassPathResource(path);
    }

    public void setIdentityProviderMetadataResourceUrl(String url) {
        this.identityProviderMetadataResource = SAML2Configuration.newUrlResource(url);
    }

    public void setIdentityProviderMetadataPath(String path) {
        this.identityProviderMetadataResource = SAML2Configuration.mapPathToResource(path);
    }

    public void setKeystoreResourceFilepath(String path) {
        this.keystoreResource = new FileSystemResource(path);
    }

    public void setKeystoreResourceClasspath(String path) {
        this.keystoreResource = new ClassPathResource(path);
    }

    public void setKeystoreResourceUrl(String url) {
        this.keystoreResource = SAML2Configuration.mapPathToResource(url);
    }

    public void setKeystorePath(String path) {
        this.keystoreResource = SAML2Configuration.mapPathToResource(path);
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getCertificateNameToAppend() {
        return this.certificateNameToAppend;
    }

    public void setCertificateNameToAppend(String certificateNameToAppend) {
        this.certificateNameToAppend = certificateNameToAppend;
    }

    public void setServiceProviderMetadataResourceFilepath(String path) {
        this.serviceProviderMetadataResource = new FileSystemResource(path);
    }

    public void setServiceProviderMetadataPath(String path) {
        this.serviceProviderMetadataResource = SAML2Configuration.mapPathToResource(path);
    }

    public LogoutHandler findLogoutHandler() {
        this.init();
        return this.logoutHandler;
    }

    private void initSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getExcludedAlgorithms());
            LOGGER.info("Bootstrapped Blacklisted Algorithms");
        }
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
            LOGGER.info("Bootstrapped Signature Algorithms");
        }
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
            this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
            LOGGER.info("Bootstrapped Signature Reference Digest Methods");
        }
        if (this.signatureCanonicalizationAlgorithm == null) {
            this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
            LOGGER.info("Bootstrapped Canonicalization Algorithm");
        }
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new SAML2HttpClientBuilder().build();
        }
        return this.httpClient;
    }

    public CredentialProvider getCredentialProvider() {
        return new KeyStoreCredentialProvider(this);
    }

    public SAML2MetadataGenerator toMetadataGenerator() {
        try {
            SAML2MetadataGenerator instance = this.getMetadataGenerator();
            if (instance instanceof BaseSAML2MetadataGenerator) {
                BaseSAML2MetadataGenerator generator = (BaseSAML2MetadataGenerator)instance;
                generator.setWantAssertionSigned(this.isWantsAssertionsSigned());
                generator.setAuthnRequestSigned(this.isAuthnRequestSigned());
                generator.setSignMetadata(this.isSignMetadata());
                generator.setNameIdPolicyFormat(this.getNameIdPolicyFormat());
                generator.setRequestedAttributes(this.getRequestedServiceProviderAttributes());
                generator.setCredentialProvider(this.getCredentialProvider());
                generator.setMetadataSigner(this.getMetadataSigner());
                generator.setEntityId(this.getServiceProviderEntityId());
                generator.setRequestInitiatorLocation(StringUtils.defaultString((String)this.requestInitiatorUrl, (String)this.callbackUrl));
                generator.setAssertionConsumerServiceUrl(StringUtils.defaultString((String)this.assertionConsumerServiceUrl, (String)this.callbackUrl));
                generator.setResponseBindingType(this.getResponseBindingType());
                this.determineSingleSignOutServiceUrl(generator);
                if (this.getBlackListedSignatureSigningAlgorithms() != null) {
                    generator.setBlackListedSignatureSigningAlgorithms(new ArrayList<String>(this.getBlackListedSignatureSigningAlgorithms()));
                }
                generator.setSignatureAlgorithms(this.getSignatureAlgorithms());
                generator.setSignatureReferenceDigestMethods(this.getSignatureReferenceDigestMethods());
                generator.setSupportedProtocols(this.getSupportedProtocols());
                generator.setContactPersons(this.getContactPersons());
                generator.setMetadataUIInfos(this.getMetadataUIInfos());
            }
            return instance;
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected void determineSingleSignOutServiceUrl(BaseSAML2MetadataGenerator generator) {
        String url = CommonHelper.ifBlank((String)this.singleSignOutServiceUrl, (String)this.callbackUrl);
        String logoutUrl = CommonHelper.addParameter((String)url, (String)"logoutendpoint", (String)"true");
        generator.setSingleLogoutServiceUrl(logoutUrl);
    }

    public SAML2MetadataGenerator getMetadataGenerator() {
        return Objects.requireNonNullElseGet(this.metadataGenerator, () -> ServiceLoader.load(SAML2MetadataGenerator.class).stream().findFirst().map(ServiceLoader.Provider::get).orElseGet(() -> {
            try {
                return this.serviceProviderMetadataResource instanceof UrlResource ? new SAML2HttpUrlMetadataGenerator(this.serviceProviderMetadataResource.getURL(), this.getHttpClient()) : new SAML2FileSystemMetadataGenerator(this.serviceProviderMetadataResource);
            }
            catch (Exception e) {
                throw new TechnicalException((Throwable)e);
            }
        }));
    }

    public SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        if (this.identityProviderMetadataResolver == null) {
            return new SAML2IdentityProviderMetadataResolver(this);
        }
        return this.identityProviderMetadataResolver;
    }

    @Generated
    public List<SAML2ScopingIdentityProvider> getScopingIdentityProviders() {
        return this.scopingIdentityProviders;
    }

    @Generated
    public List<SAML2ServiceProviderRequestedAttribute> getRequestedServiceProviderAttributes() {
        return this.requestedServiceProviderAttributes;
    }

    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Generated
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Generated
    public SAML2MetadataSigner getMetadataSigner() {
        return this.metadataSigner;
    }

    @Generated
    public String getSingleSignOutServiceUrl() {
        return this.singleSignOutServiceUrl;
    }

    @Generated
    public String getNameIdAttribute() {
        return this.nameIdAttribute;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public String getRequestInitiatorUrl() {
        return this.requestInitiatorUrl;
    }

    @Generated
    public String getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    @Generated
    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    @Generated
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Generated
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Generated
    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    @Generated
    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    @Generated
    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    @Generated
    public long getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    @Generated
    public long getAcceptedSkew() {
        return this.acceptedSkew;
    }

    @Generated
    public boolean isForceAuth() {
        return this.forceAuth;
    }

    @Generated
    public boolean isPassive() {
        return this.passive;
    }

    @Generated
    public String getComparisonType() {
        return this.comparisonType;
    }

    @Generated
    public boolean isPartialLogoutTreatedAsSuccess() {
        return this.isPartialLogoutTreatedAsSuccess;
    }

    @Generated
    public String getAuthnRequestBindingType() {
        return this.authnRequestBindingType;
    }

    @Generated
    public String getResponseBindingType() {
        return this.responseBindingType;
    }

    @Generated
    public String getSpLogoutRequestBindingType() {
        return this.spLogoutRequestBindingType;
    }

    @Generated
    public String getSpLogoutResponseBindingType() {
        return this.spLogoutResponseBindingType;
    }

    @Generated
    public List<String> getAuthnContextClassRefs() {
        return this.authnContextClassRefs;
    }

    @Generated
    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    @Generated
    public boolean isUseNameQualifier() {
        return this.useNameQualifier;
    }

    @Generated
    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    @Generated
    public Resource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    @Generated
    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    @Generated
    public boolean isForceKeystoreGeneration() {
        return this.forceKeystoreGeneration;
    }

    @Generated
    public SAMLMessageStoreFactory getSamlMessageStoreFactory() {
        return this.samlMessageStoreFactory;
    }

    @Generated
    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    @Generated
    public boolean isSpLogoutRequestSigned() {
        return this.spLogoutRequestSigned;
    }

    @Generated
    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    @Generated
    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    @Generated
    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    @Generated
    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    @Generated
    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    @Generated
    public boolean isWantsResponsesSigned() {
        return this.wantsResponsesSigned;
    }

    @Generated
    public boolean isAllSignatureValidationDisabled() {
        return this.allSignatureValidationDisabled;
    }

    @Generated
    public boolean isResponseDestinationAttributeMandatory() {
        return this.responseDestinationAttributeMandatory;
    }

    @Generated
    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public int getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    @Generated
    public int getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public Supplier<List<XSAny>> getAuthnRequestExtensions() {
        return this.authnRequestExtensions;
    }

    @Generated
    public String getAttributeAsId() {
        return this.attributeAsId;
    }

    @Generated
    public Map<String, String> getMappedAttributes() {
        return this.mappedAttributes;
    }

    @Generated
    public URIComparator getUriComparator() {
        return this.uriComparator;
    }

    @Generated
    public LogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    @Generated
    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    @Generated
    public Period getCertificateExpirationPeriod() {
        return this.certificateExpirationPeriod;
    }

    @Generated
    public String getCertificateSignatureAlg() {
        return this.certificateSignatureAlg;
    }

    @Generated
    public int getPrivateKeySize() {
        return this.privateKeySize;
    }

    @Generated
    public List<SAML2MetadataContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @Generated
    public List<SAML2MetadataUIInfo> getMetadataUIInfos() {
        return this.metadataUIInfos;
    }

    @Generated
    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    @Generated
    public AttributeConverter getSamlAttributeConverter() {
        return this.samlAttributeConverter;
    }

    @Generated
    public Boolean getNameIdPolicyAllowCreate() {
        return this.nameIdPolicyAllowCreate;
    }

    @Generated
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @Generated
    public int getIdentityProviderMetadataConnectTimeout() {
        return this.identityProviderMetadataConnectTimeout;
    }

    @Generated
    public int getIdentityProviderMetadataReadTimeout() {
        return this.identityProviderMetadataReadTimeout;
    }

    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Generated
    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Generated
    public void setMetadataSigner(SAML2MetadataSigner metadataSigner) {
        this.metadataSigner = metadataSigner;
    }

    @Generated
    public void setSingleSignOutServiceUrl(String singleSignOutServiceUrl) {
        this.singleSignOutServiceUrl = singleSignOutServiceUrl;
    }

    @Generated
    public void setNameIdAttribute(String nameIdAttribute) {
        this.nameIdAttribute = nameIdAttribute;
    }

    @Generated
    public void setRequestInitiatorUrl(String requestInitiatorUrl) {
        this.requestInitiatorUrl = requestInitiatorUrl;
    }

    @Generated
    public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    @Generated
    public void setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    @Generated
    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Generated
    public void setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
    }

    @Generated
    public void setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
    }

    @Generated
    public void setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    @Generated
    public void setMaximumAuthenticationLifetime(long maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    @Generated
    public void setAcceptedSkew(long acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    @Generated
    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    @Generated
    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    @Generated
    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    @Generated
    public void setPartialLogoutTreatedAsSuccess(boolean isPartialLogoutTreatedAsSuccess) {
        this.isPartialLogoutTreatedAsSuccess = isPartialLogoutTreatedAsSuccess;
    }

    @Generated
    public void setAuthnRequestBindingType(String authnRequestBindingType) {
        this.authnRequestBindingType = authnRequestBindingType;
    }

    @Generated
    public void setResponseBindingType(String responseBindingType) {
        this.responseBindingType = responseBindingType;
    }

    @Generated
    public void setSpLogoutRequestBindingType(String spLogoutRequestBindingType) {
        this.spLogoutRequestBindingType = spLogoutRequestBindingType;
    }

    @Generated
    public void setSpLogoutResponseBindingType(String spLogoutResponseBindingType) {
        this.spLogoutResponseBindingType = spLogoutResponseBindingType;
    }

    @Generated
    public void setAuthnContextClassRefs(List<String> authnContextClassRefs) {
        this.authnContextClassRefs = authnContextClassRefs;
    }

    @Generated
    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    @Generated
    public void setUseNameQualifier(boolean useNameQualifier) {
        this.useNameQualifier = useNameQualifier;
    }

    @Generated
    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    @Generated
    public void setServiceProviderMetadataResource(Resource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
    }

    @Generated
    public void setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
    }

    @Generated
    public void setForceKeystoreGeneration(boolean forceKeystoreGeneration) {
        this.forceKeystoreGeneration = forceKeystoreGeneration;
    }

    @Generated
    public void setSamlMessageStoreFactory(SAMLMessageStoreFactory samlMessageStoreFactory) {
        this.samlMessageStoreFactory = samlMessageStoreFactory;
    }

    @Generated
    public void setKeystoreGenerator(SAML2KeystoreGenerator keystoreGenerator) {
        this.keystoreGenerator = keystoreGenerator;
    }

    @Generated
    public void setMetadataGenerator(SAML2MetadataGenerator metadataGenerator) {
        this.metadataGenerator = metadataGenerator;
    }

    @Generated
    public void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    @Generated
    public void setSpLogoutRequestSigned(boolean spLogoutRequestSigned) {
        this.spLogoutRequestSigned = spLogoutRequestSigned;
    }

    @Generated
    public void setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    @Generated
    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    @Generated
    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    @Generated
    public void setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
    }

    @Generated
    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    @Generated
    public void setWantsResponsesSigned(boolean wantsResponsesSigned) {
        this.wantsResponsesSigned = wantsResponsesSigned;
    }

    @Generated
    public void setAllSignatureValidationDisabled(boolean allSignatureValidationDisabled) {
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
    }

    @Generated
    public void setResponseDestinationAttributeMandatory(boolean responseDestinationAttributeMandatory) {
        this.responseDestinationAttributeMandatory = responseDestinationAttributeMandatory;
    }

    @Generated
    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setAssertionConsumerServiceIndex(int assertionConsumerServiceIndex) {
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
    }

    @Generated
    public void setAttributeConsumingServiceIndex(int attributeConsumingServiceIndex) {
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
    }

    @Generated
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Generated
    public void setAuthnRequestExtensions(Supplier<List<XSAny>> authnRequestExtensions) {
        this.authnRequestExtensions = authnRequestExtensions;
    }

    @Generated
    public void setAttributeAsId(String attributeAsId) {
        this.attributeAsId = attributeAsId;
    }

    @Generated
    public void setMappedAttributes(Map<String, String> mappedAttributes) {
        this.mappedAttributes = mappedAttributes;
    }

    @Generated
    public void setUriComparator(URIComparator uriComparator) {
        this.uriComparator = uriComparator;
    }

    @Generated
    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    @Generated
    public void setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
    }

    @Generated
    public void setCertificateExpirationPeriod(Period certificateExpirationPeriod) {
        this.certificateExpirationPeriod = certificateExpirationPeriod;
    }

    @Generated
    public void setCertificateSignatureAlg(String certificateSignatureAlg) {
        this.certificateSignatureAlg = certificateSignatureAlg;
    }

    @Generated
    public void setPrivateKeySize(int privateKeySize) {
        this.privateKeySize = privateKeySize;
    }

    @Generated
    public void setContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
    }

    @Generated
    public void setMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        this.metadataUIInfos = metadataUIInfos;
    }

    @Generated
    public void setIssuerFormat(String issuerFormat) {
        this.issuerFormat = issuerFormat;
    }

    @Generated
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Generated
    public void setSamlAttributeConverter(AttributeConverter samlAttributeConverter) {
        this.samlAttributeConverter = samlAttributeConverter;
    }

    @Generated
    public void setNameIdPolicyAllowCreate(Boolean nameIdPolicyAllowCreate) {
        this.nameIdPolicyAllowCreate = nameIdPolicyAllowCreate;
    }

    @Generated
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @Generated
    public void setIdentityProviderMetadataResolver(SAML2MetadataResolver identityProviderMetadataResolver) {
        this.identityProviderMetadataResolver = identityProviderMetadataResolver;
    }

    @Generated
    public void setIdentityProviderMetadataConnectTimeout(int identityProviderMetadataConnectTimeout) {
        this.identityProviderMetadataConnectTimeout = identityProviderMetadataConnectTimeout;
    }

    @Generated
    public void setIdentityProviderMetadataReadTimeout(int identityProviderMetadataReadTimeout) {
        this.identityProviderMetadataReadTimeout = identityProviderMetadataReadTimeout;
    }
}

