/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2Credentials
extends Credentials {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2Credentials.class);
    private static final long serialVersionUID = 5040516205957826527L;
    private final SAMLNameID nameId;
    private final String sessionIndex;
    private final List<SAMLAttribute> attributes;
    private final SAMLConditions conditions;
    private final String issuerId;
    private final List<String> authnContexts;
    private final String inResponseTo;

    public SAML2Credentials(SAMLNameID nameId, String issuerId, List<SAMLAttribute> samlAttributes, Conditions conditions, String sessionIndex, List<String> authnContexts, String inResponseTo) {
        this.nameId = nameId;
        this.issuerId = issuerId;
        this.sessionIndex = sessionIndex;
        this.attributes = samlAttributes;
        this.inResponseTo = inResponseTo;
        if (conditions != null) {
            this.conditions = new SAMLConditions();
            if (conditions.getNotBefore() != null) {
                this.conditions.setNotBefore(ZonedDateTime.ofInstant(conditions.getNotBefore(), ZoneOffset.UTC));
            }
            if (conditions.getNotOnOrAfter() != null) {
                this.conditions.setNotOnOrAfter(ZonedDateTime.ofInstant(conditions.getNotOnOrAfter(), ZoneOffset.UTC));
            }
        } else {
            this.conditions = null;
        }
        this.authnContexts = authnContexts;
        LOGGER.info("Constructed SAML2 credentials: {}", (Object)this);
    }

    @Generated
    public SAMLNameID getNameId() {
        return this.nameId;
    }

    @Generated
    public String getSessionIndex() {
        return this.sessionIndex;
    }

    @Generated
    public List<SAMLAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public SAMLConditions getConditions() {
        return this.conditions;
    }

    @Generated
    public String getIssuerId() {
        return this.issuerId;
    }

    @Generated
    public List<String> getAuthnContexts() {
        return this.authnContexts;
    }

    @Generated
    public String getInResponseTo() {
        return this.inResponseTo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SAML2Credentials)) {
            return false;
        }
        SAML2Credentials other = (SAML2Credentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SAMLNameID this$nameId = this.nameId;
        SAMLNameID other$nameId = other.nameId;
        if (this$nameId == null ? other$nameId != null : !this$nameId.equals(other$nameId)) {
            return false;
        }
        String this$sessionIndex = this.sessionIndex;
        String other$sessionIndex = other.sessionIndex;
        if (this$sessionIndex == null ? other$sessionIndex != null : !this$sessionIndex.equals(other$sessionIndex)) {
            return false;
        }
        List<SAMLAttribute> this$attributes = this.attributes;
        List<SAMLAttribute> other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        SAMLConditions this$conditions = this.conditions;
        SAMLConditions other$conditions = other.conditions;
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        String this$issuerId = this.issuerId;
        String other$issuerId = other.issuerId;
        if (this$issuerId == null ? other$issuerId != null : !this$issuerId.equals(other$issuerId)) {
            return false;
        }
        List<String> this$authnContexts = this.authnContexts;
        List<String> other$authnContexts = other.authnContexts;
        if (this$authnContexts == null ? other$authnContexts != null : !((Object)this$authnContexts).equals(other$authnContexts)) {
            return false;
        }
        String this$inResponseTo = this.inResponseTo;
        String other$inResponseTo = other.inResponseTo;
        return !(this$inResponseTo == null ? other$inResponseTo != null : !this$inResponseTo.equals(other$inResponseTo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SAML2Credentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SAMLNameID $nameId = this.nameId;
        result = result * 59 + ($nameId == null ? 43 : $nameId.hashCode());
        String $sessionIndex = this.sessionIndex;
        result = result * 59 + ($sessionIndex == null ? 43 : $sessionIndex.hashCode());
        List<SAMLAttribute> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        SAMLConditions $conditions = this.conditions;
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        String $issuerId = this.issuerId;
        result = result * 59 + ($issuerId == null ? 43 : $issuerId.hashCode());
        List<String> $authnContexts = this.authnContexts;
        result = result * 59 + ($authnContexts == null ? 43 : ((Object)$authnContexts).hashCode());
        String $inResponseTo = this.inResponseTo;
        result = result * 59 + ($inResponseTo == null ? 43 : $inResponseTo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SAML2Credentials(nameId=" + this.nameId + ", sessionIndex=" + this.sessionIndex + ", attributes=" + this.attributes + ", conditions=" + this.conditions + ", issuerId=" + this.issuerId + ", authnContexts=" + this.authnContexts + ", inResponseTo=" + this.inResponseTo + ")";
    }

    public static class SAMLNameID
    implements Serializable {
        private static final long serialVersionUID = -7913473743778305079L;
        private String format;
        private String nameQualifier;
        private String spNameQualifier;
        private String spProviderId;
        private String value;

        public static SAMLNameID from(NameID nameId) {
            SAMLNameID result = new SAMLNameID();
            result.setNameQualifier(nameId.getNameQualifier());
            result.setFormat(nameId.getFormat());
            result.setSpNameQualifier(nameId.getSPNameQualifier());
            result.setSpProviderId(nameId.getSPProvidedID());
            result.setValue(nameId.getValue());
            return result;
        }

        public static SAMLNameID from(SAMLAttribute attribute) {
            SAMLNameID result = new SAMLNameID();
            result.setValue(attribute.getAttributeValues().get(0));
            result.setFormat(attribute.getNameFormat());
            result.setNameQualifier(attribute.getName());
            result.setSpNameQualifier(attribute.getFriendlyName());
            return result;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public String getNameQualifier() {
            return this.nameQualifier;
        }

        @Generated
        public String getSpNameQualifier() {
            return this.spNameQualifier;
        }

        @Generated
        public String getSpProviderId() {
            return this.spProviderId;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setFormat(String format) {
            this.format = format;
        }

        @Generated
        public void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        @Generated
        public void setSpNameQualifier(String spNameQualifier) {
            this.spNameQualifier = spNameQualifier;
        }

        @Generated
        public void setSpProviderId(String spProviderId) {
            this.spProviderId = spProviderId;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public String toString() {
            return "SAML2Credentials.SAMLNameID(format=" + this.format + ", nameQualifier=" + this.nameQualifier + ", spNameQualifier=" + this.spNameQualifier + ", spProviderId=" + this.spProviderId + ", value=" + this.value + ")";
        }
    }

    public static class SAMLConditions
    implements Serializable {
        private static final long serialVersionUID = -8966585574672014553L;
        private ZonedDateTime notBefore;
        private ZonedDateTime notOnOrAfter;

        @Generated
        public ZonedDateTime getNotBefore() {
            return this.notBefore;
        }

        @Generated
        public ZonedDateTime getNotOnOrAfter() {
            return this.notOnOrAfter;
        }

        @Generated
        public void setNotBefore(ZonedDateTime notBefore) {
            this.notBefore = notBefore;
        }

        @Generated
        public void setNotOnOrAfter(ZonedDateTime notOnOrAfter) {
            this.notOnOrAfter = notOnOrAfter;
        }

        @Generated
        public String toString() {
            return "SAML2Credentials.SAMLConditions(notBefore=" + this.notBefore + ", notOnOrAfter=" + this.notOnOrAfter + ")";
        }
    }

    public static class SAMLAttribute
    implements Serializable {
        private static final long serialVersionUID = 2532838901563948260L;
        private String friendlyName;
        private String name;
        private String nameFormat;
        private List<String> attributeValues = new ArrayList<String>();

        public static List<SAMLAttribute> from(AttributeConverter samlAttributeConverter, List<Attribute> samlAttributes) {
            ArrayList<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>();
            samlAttributes.forEach(attribute -> {
                Object result = samlAttributeConverter.convert(attribute);
                if (result instanceof Collection) {
                    attributes.addAll((Collection)result);
                } else {
                    attributes.add((SAMLAttribute)result);
                }
            });
            return attributes;
        }

        @Generated
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNameFormat() {
            return this.nameFormat;
        }

        @Generated
        public List<String> getAttributeValues() {
            return this.attributeValues;
        }

        @Generated
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
        }

        @Generated
        public void setAttributeValues(List<String> attributeValues) {
            this.attributeValues = attributeValues;
        }

        @Generated
        public String toString() {
            return "SAML2Credentials.SAMLAttribute(friendlyName=" + this.friendlyName + ", name=" + this.name + ", nameFormat=" + this.nameFormat + ", attributeValues=" + this.attributeValues + ")";
        }
    }
}

