/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.extractor;

import java.util.Optional;
import lombok.Generated;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.factory.ProfileManagerFactory;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseMessageSender;
import org.pac4j.saml.profile.api.SAML2ProfileHandler;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2CredentialsExtractor
implements CredentialsExtractor {
    protected final SAMLContextProvider contextProvider;
    protected final SAML2ProfileHandler<AuthnRequest> profileHandler;
    protected final SAML2ProfileHandler<LogoutRequest> logoutProfileHandler;
    protected final String spLogoutResponseBindingType;
    protected SAML2LogoutResponseBuilder saml2LogoutResponseBuilder;
    protected final SAML2LogoutResponseMessageSender saml2LogoutResponseMessageSender;
    protected final SAML2Client saml2Client;

    public SAML2CredentialsExtractor(SAML2Client client) {
        this.saml2Client = client;
        this.contextProvider = client.getContextProvider();
        this.profileHandler = client.getProfileHandler();
        this.logoutProfileHandler = client.getLogoutProfileHandler();
        this.spLogoutResponseBindingType = client.getConfiguration().getSpLogoutResponseBindingType();
        this.saml2LogoutResponseBuilder = new SAML2LogoutResponseBuilder(this.spLogoutResponseBindingType);
        this.saml2LogoutResponseMessageSender = new SAML2LogoutResponseMessageSender(client.getSignatureSigningParametersProvider(), this.spLogoutResponseBindingType, false, client.getConfiguration().isSpLogoutRequestSigned());
    }

    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore, ProfileManagerFactory profileManagerFactory) {
        SAML2MessageContext samlContext = this.contextProvider.buildContext(this.saml2Client, context, sessionStore);
        boolean logoutEndpoint = this.isLogoutEndpointRequest(context, samlContext);
        if (logoutEndpoint) {
            this.receiveLogout(samlContext);
            this.sendLogoutResponse(samlContext);
            this.adaptLogoutResponseToBinding(context, samlContext);
            return Optional.empty();
        }
        return this.receiveLogin(samlContext, context);
    }

    protected Optional<Credentials> receiveLogin(SAML2MessageContext samlContext, WebContext context) {
        samlContext.setSaml2Configuration(this.saml2Client.getConfiguration());
        SAML2Credentials credentials = (SAML2Credentials)this.profileHandler.receive(samlContext);
        return Optional.ofNullable(credentials);
    }

    protected void adaptLogoutResponseToBinding(WebContext context, SAML2MessageContext samlContext) {
        Pac4jSAMLResponse adapter = samlContext.getProfileRequestContextOutboundMessageTransportResponse();
        if (this.spLogoutResponseBindingType.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String content = adapter.getOutgoingContent();
            throw HttpActionHelper.buildFormPostContentAction((WebContext)context, (String)content);
        }
        String location = adapter.getRedirectUrl();
        throw HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)location);
    }

    protected void sendLogoutResponse(SAML2MessageContext samlContext) {
        LogoutResponse logoutResponse = this.saml2LogoutResponseBuilder.build(samlContext);
        this.saml2LogoutResponseMessageSender.sendMessage(samlContext, logoutResponse, samlContext.getSAMLBindingContext().getRelayState());
    }

    protected void receiveLogout(SAML2MessageContext samlContext) {
        samlContext.setSaml2Configuration(this.saml2Client.getConfiguration());
        this.logoutProfileHandler.receive(samlContext);
    }

    protected boolean isLogoutEndpointRequest(WebContext context, SAML2MessageContext samlContext) {
        return context.getRequestParameter("logoutendpoint").isPresent();
    }

    @Generated
    public SAML2LogoutResponseBuilder getSaml2LogoutResponseBuilder() {
        return this.saml2LogoutResponseBuilder;
    }

    @Generated
    public void setSaml2LogoutResponseBuilder(SAML2LogoutResponseBuilder saml2LogoutResponseBuilder) {
        this.saml2LogoutResponseBuilder = saml2LogoutResponseBuilder;
    }
}

