/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.util.ArrayList;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignatureSigningParametersProvider
implements SignatureSigningParametersProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSignatureSigningParametersProvider.class);
    private final SAML2Configuration configuration;

    public DefaultSignatureSigningParametersProvider(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public SignatureSigningParameters build(SSODescriptor descriptor) {
        try {
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{this.getSignatureSigningConfiguration()}));
            criteria.add((Object)new RoleDescriptorCriterion((RoleDescriptor)descriptor));
            SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
            SignatureSigningParameters params = resolver.resolveSingle(criteria);
            this.augmentSignatureSigningParameters(params);
            if (params == null) {
                throw new SAMLException("Could not determine the signature parameters");
            }
            LOGGER.info("Created signature signing parameters.\nSignature algorithm: {}\nSignature canonicalization algorithm: {}\nSignature reference digest methods: {}", new Object[]{params.getSignatureAlgorithm(), params.getSignatureCanonicalizationAlgorithm(), params.getSignatureReferenceDigestMethod()});
            return params;
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected SignatureSigningConfiguration getSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.configuration.getBlackListedSignatureSigningAlgorithms() != null) {
            config.setExcludedAlgorithms(this.configuration.getBlackListedSignatureSigningAlgorithms());
        }
        if (this.configuration.getSignatureAlgorithms() != null) {
            config.setSignatureAlgorithms(this.configuration.getSignatureAlgorithms());
        }
        if (this.configuration.getSignatureCanonicalizationAlgorithm() != null) {
            config.setSignatureCanonicalizationAlgorithm(this.configuration.getSignatureCanonicalizationAlgorithm());
        }
        if (this.configuration.getSignatureReferenceDigestMethods() != null) {
            config.setSignatureReferenceDigestMethods(this.configuration.getSignatureReferenceDigestMethods());
        }
        ArrayList<Credential> creds = new ArrayList<Credential>();
        creds.add(this.configuration.getCredentialProvider().getCredential());
        config.setSigningCredentials(creds);
        return config;
    }

    protected SignatureSigningParameters augmentSignatureSigningParameters(SignatureSigningParameters params) {
        return params;
    }
}

