/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.net.URL;
import java.time.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;

public class SAML2HttpUrlMetadataGenerator
extends BaseSAML2MetadataGenerator {
    private final URL metadataUrl;
    private final HttpClient httpClient;
    private float refreshDelayFactor = -1.0f;
    private Duration maxRefreshDelay;
    private Duration minRefreshDelay;

    public SAML2HttpUrlMetadataGenerator(URL metadataUrl, HttpClient httpClient) {
        this.metadataUrl = metadataUrl;
        this.httpClient = httpClient;
    }

    @Override
    protected AbstractMetadataResolver createMetadataResolver() throws Exception {
        HTTPMetadataResolver resolver = new HTTPMetadataResolver(this.httpClient, this.metadataUrl.toExternalForm());
        if (this.minRefreshDelay != null) {
            resolver.setMinRefreshDelay(this.minRefreshDelay);
        }
        if (this.maxRefreshDelay != null) {
            resolver.setMaxRefreshDelay(this.maxRefreshDelay);
        }
        if (this.refreshDelayFactor >= 0.0f) {
            resolver.setRefreshDelayFactor(this.refreshDelayFactor);
        }
        return resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMetadata(String metadata, boolean force) throws Exception {
        HttpResponse response = null;
        try {
            this.logger.debug("Posting metadata to {}", (Object)this.metadataUrl.toURI());
            HttpPost httpPost = new HttpPost(this.metadataUrl.toURI());
            httpPost.addHeader("Accept", ContentType.APPLICATION_XML.getMimeType());
            httpPost.addHeader("Content-Type", ContentType.APPLICATION_XML.getMimeType());
            httpPost.setEntity((HttpEntity)new StringEntity(metadata, ContentType.APPLICATION_XML));
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                int code = response.getStatusLine().getStatusCode();
                if (code == 501) {
                    this.logger.info("Storing metadata is not supported/implemented by {}", (Object)this.metadataUrl);
                    boolean bl = false;
                    return bl;
                }
                if (code == 200 || code == 201) {
                    this.logger.info("Successfully submitted metadata to {}", (Object)this.metadataUrl);
                    boolean bl = true;
                    return bl;
                }
            }
            this.logger.error("Unable to store metadata successfully via {}", (Object)this.metadataUrl.toExternalForm());
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
    }

    public URL getMetadataUrl() {
        return this.metadataUrl;
    }

    public float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(float refreshDelayFactor) {
        this.refreshDelayFactor = refreshDelayFactor;
    }

    public Duration getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMaxRefreshDelay(Duration maxRefreshDelay) {
        this.maxRefreshDelay = maxRefreshDelay;
    }

    public Duration getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    public void setMinRefreshDelay(Duration minRefreshDelay) {
        this.minRefreshDelay = minRefreshDelay;
    }
}

