/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.springframework.core.io.Resource;

public class SAML2ServiceProviderMetadataResolver
implements SAML2MetadataResolver {
    protected final SAML2Configuration configuration;
    private MetadataResolver metadataResolver;

    public SAML2ServiceProviderMetadataResolver(SAML2Configuration configuration) {
        this.configuration = configuration;
        this.metadataResolver = this.prepareServiceProviderMetadata();
    }

    public void destroy() {
        if (this.metadataResolver instanceof FilesystemMetadataResolver) {
            ((FilesystemMetadataResolver)this.metadataResolver).destroy();
            this.metadataResolver = null;
        }
    }

    protected MetadataResolver prepareServiceProviderMetadata() {
        try {
            SAML2MetadataGenerator metadataGenerator = this.configuration.toMetadataGenerator();
            Resource resource = this.configuration.getServiceProviderMetadataResource();
            if (resource == null || !resource.exists() || this.configuration.isForceServiceProviderMetadataGeneration()) {
                EntityDescriptor entity = metadataGenerator.buildEntityDescriptor();
                String metadata = metadataGenerator.getMetadata(entity);
                metadataGenerator.storeMetadata(metadata, this.configuration.isForceServiceProviderMetadataGeneration());
            }
            return metadataGenerator.buildMetadataResolver();
        }
        catch (Exception e) {
            throw new SAMLException("Unable to generate metadata for service provider", e);
        }
    }

    @Override
    public final MetadataResolver resolve(boolean force) {
        return this.metadataResolver;
    }

    @Override
    public final String getEntityId() {
        return this.configuration.getServiceProviderEntityId();
    }

    @Override
    public String getMetadata() {
        try {
            SAML2MetadataGenerator metadataGenerator = this.configuration.toMetadataGenerator();
            EntityDescriptor entity = metadataGenerator.buildEntityDescriptor();
            return metadataGenerator.getMetadata(entity);
        }
        catch (Exception e) {
            throw new SAMLException("Unable to fetch metadata", e);
        }
    }

    @Override
    public XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.getEntityId())}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Unable to resolve metadata", e);
        }
    }
}

