/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.util.Configuration;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2JdbcMetadataGenerator
extends BaseSAML2MetadataGenerator {
    private String tableName = "sp-metadata";
    private final JdbcTemplate template;
    private final String entityId;

    public SAML2JdbcMetadataGenerator(JdbcTemplate template, String entityId) {
        this.template = template;
        this.entityId = entityId;
    }

    @Override
    public AbstractMetadataResolver createMetadataResolver() throws Exception {
        String sql = String.format("SELECT metadata FROM `%s` WHERE entityId='%s'", this.tableName, this.entityId);
        byte[] metadata = this.decodeMetadata((String)this.template.queryForObject(sql, String.class));
        try (ByteArrayInputStream is = new ByteArrayInputStream(metadata);){
            Document document = Configuration.getParserPool().parse((InputStream)is);
            Element root = document.getDocumentElement();
            DOMMetadataResolver dOMMetadataResolver = new DOMMetadataResolver(root);
            return dOMMetadataResolver;
        }
    }

    protected byte[] decodeMetadata(String metadata) {
        return Base64.getDecoder().decode(metadata);
    }

    @Override
    public boolean storeMetadata(String metadata, boolean force) {
        if (CommonHelper.isBlank((String)metadata)) {
            this.logger.info("No metadata is provided");
            return false;
        }
        String metadataToUse = this.isSignMetadata() ? this.getMetadataSigner().sign(metadata) : metadata;
        CommonHelper.assertNotBlank((String)"metadata", (String)metadataToUse);
        String metadataEntityId = Configuration.deserializeSamlObject(metadataToUse).map(EntityDescriptor.class::cast).map(EntityDescriptor::getEntityID).orElseThrow();
        if (!metadataEntityId.equals(this.entityId)) {
            throw new SAMLException("Entity id from metadata " + metadataEntityId + " does not match supplied entity id " + this.entityId);
        }
        try {
            String sql = String.format("SELECT entityId FROM `%s` WHERE entityId='%s'", this.tableName, this.entityId);
            String metadataId = (String)this.template.queryForObject(sql, String.class);
            this.logger.debug("Updating metadata entity [{}]", (Object)metadataId);
            sql = String.format("UPDATE `%s` SET metadata='%s' WHERE entityId='%s'", this.tableName, this.encodeMetadata(metadataToUse), metadataId);
            int count = this.template.update(sql);
            return count > 0;
        }
        catch (EmptyResultDataAccessException e) {
            SimpleJdbcInsert insert = new SimpleJdbcInsert(this.template).withTableName(String.format("`%s`", this.tableName)).usingColumns(new String[]{"entityId", "metadata"});
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("entityId", this.entityId);
            parameters.put("metadata", this.encodeMetadata(metadataToUse));
            return insert.execute(parameters) > 0;
        }
    }

    protected String encodeMetadata(String metadataToUse) {
        return Base64.getEncoder().encodeToString(metadataToUse.getBytes(StandardCharsets.UTF_8));
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

