/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.processor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.logout.processor.LogoutProcessor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseMessageSender;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2LogoutProcessor
implements LogoutProcessor {
    private final SAMLContextProvider contextProvider;
    private final SAML2Client saml2Client;
    private final String spLogoutResponseBindingType;
    private final SAML2LogoutResponseBuilder saml2LogoutResponseBuilder;
    private final SAML2LogoutResponseMessageSender saml2LogoutResponseMessageSender;
    private String postLogoutURL;
    private boolean actionOnSuccess = true;

    public SAML2LogoutProcessor(SAML2Client client) {
        this.contextProvider = client.getContextProvider();
        this.saml2Client = client;
        this.spLogoutResponseBindingType = client.getConfiguration().getSpLogoutResponseBindingType();
        this.saml2LogoutResponseBuilder = new SAML2LogoutResponseBuilder(this.spLogoutResponseBindingType);
        this.saml2LogoutResponseMessageSender = new SAML2LogoutResponseMessageSender(client.getSignatureSigningParametersProvider(), this.spLogoutResponseBindingType, false, client.getConfiguration().isSpLogoutRequestSigned());
        this.postLogoutURL = client.getConfiguration().getPostLogoutURL();
    }

    public HttpAction processLogout(CallContext ctx, Credentials credentials) {
        SAML2Credentials saml2Credentials = (SAML2Credentials)credentials;
        SAMLObject message = (SAMLObject)saml2Credentials.getContext().getMessageContext().getMessage();
        SAML2MessageContext samlContext = this.contextProvider.buildContext(ctx, this.saml2Client);
        if (message instanceof LogoutRequest) {
            this.sendLogoutResponse(samlContext, saml2Credentials);
            return this.adaptLogoutResponseToBinding(ctx.webContext(), samlContext);
        }
        if (message instanceof LogoutResponse) {
            HttpAction action = this.handlePostLogoutResponse(samlContext);
            if (action != null) {
                return action;
            }
            return NoContentAction.INSTANCE;
        }
        throw new SAMLException("SAML message must be a LogoutRequest or LogoutResponse type");
    }

    protected void sendLogoutResponse(SAML2MessageContext samlContext, SAML2Credentials saml2Credentials) {
        samlContext.getSAMLBindingContext().setRelayState(saml2Credentials.getContext().getSAMLBindingContext().getRelayState());
        LogoutResponse logoutResponse = this.saml2LogoutResponseBuilder.build(samlContext);
        this.saml2LogoutResponseMessageSender.sendMessage(samlContext, logoutResponse, samlContext.getSAMLBindingContext().getRelayState());
    }

    protected HttpAction adaptLogoutResponseToBinding(WebContext context, SAML2MessageContext samlContext) {
        Pac4jSAMLResponse adapter = samlContext.getProfileRequestContextOutboundMessageTransportResponse();
        if (this.spLogoutResponseBindingType.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String content = adapter.getOutgoingContent();
            return HttpActionHelper.buildFormPostContentAction((WebContext)context, (String)content);
        }
        String location = adapter.getRedirectUrl();
        return HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)location);
    }

    protected HttpAction handlePostLogoutResponse(SAML2MessageContext context) {
        if (CommonHelper.isNotBlank((String)this.postLogoutURL)) {
            return new FoundAction(this.postLogoutURL);
        }
        return this.actionOnSuccess ? new OkAction("") : null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isActionOnSuccess() {
        return this.actionOnSuccess;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setActionOnSuccess(boolean actionOnSuccess) {
        this.actionOnSuccess = actionOnSuccess;
    }
}

