/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.play.context.PlayContextFactory;
import org.pac4j.play.http.PlayHttpActionAdapter;
import play.libs.concurrent.HttpExecutionContext;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

public class CallbackController
extends Controller {
    private CallbackLogic callbackLogic;
    private String defaultUrl;
    private Boolean renewSession;
    private String defaultClient;
    @Inject
    protected Config config;
    @Inject
    protected SessionStore sessionStore;
    @Inject
    protected HttpExecutionContext ec;

    public CompletionStage<Result> callback(Http.Request request) {
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)PlayHttpActionAdapter.INSTANCE);
        CallbackLogic bestLogic = FindBest.callbackLogic((CallbackLogic)this.callbackLogic, (Config)this.config, (CallbackLogic)DefaultCallbackLogic.INSTANCE);
        WebContext context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)PlayContextFactory.INSTANCE).newContext(new Object[]{request});
        return CompletableFuture.supplyAsync(() -> (Result)bestLogic.perform(context, this.sessionStore, this.config, bestAdapter, this.defaultUrl, this.renewSession, this.defaultClient), this.ec.current());
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public CallbackLogic getCallbackLogic() {
        return this.callbackLogic;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setCallbackLogic(CallbackLogic callbackLogic) {
        this.callbackLogic = callbackLogic;
    }
}

