/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.ScalaCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.mvc.AnyContentAsFormUrlEncoded;
import play.api.mvc.AnyContentAsText;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.api.mvc.request.AssignedCell;
import play.api.mvc.request.RequestAttrKey;
import play.libs.typedmap.TypedKey;
import play.mvc.Http;
import play.mvc.Result;

public class PlayWebContext
implements WebContext {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final TypedKey<Map<String, Object>> PAC4J_REQUEST_ATTRIBUTES = TypedKey.create((String)"pac4jRequestAttributes");
    protected Http.RequestHeader javaRequest;
    protected RequestHeader scalaRequest;
    protected String requestContent;
    protected Map<String, String> responseHeaders = new HashMap<String, String>();
    protected List<Http.Cookie> responseCookies = new ArrayList<Http.Cookie>();
    protected String responseContentType;
    protected Http.Session session;

    public PlayWebContext(Http.RequestHeader javaRequest) {
        CommonHelper.assertNotNull((String)"request", (Object)javaRequest);
        this.javaRequest = javaRequest;
        this.session = javaRequest.session();
    }

    public PlayWebContext(RequestHeader scalaRequest) {
        this(scalaRequest.asJava());
        this.scalaRequest = scalaRequest;
    }

    public Http.RequestHeader getNativeJavaRequest() {
        return this.javaRequest;
    }

    public RequestHeader getNativeScalaRequest() {
        return this.scalaRequest;
    }

    public Optional<String> getRequestHeader(String name) {
        return this.javaRequest.header(name);
    }

    public String getRequestMethod() {
        return this.javaRequest.method();
    }

    public Optional<String> getRequestParameter(String name) {
        Map<String, String[]> parameters = this.getRequestParameters();
        String[] values = parameters.get(name);
        if (values != null && values.length > 0) {
            return Optional.of(values[0]);
        }
        return Optional.empty();
    }

    public Map<String, String[]> getRequestParameters() {
        Map urlParameters;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        Object body = this.getBody();
        Map<String, String[]> p = null;
        if (body instanceof Http.RequestBody) {
            p = ((Http.RequestBody)body).asFormUrlEncoded();
        } else if (body instanceof AnyContentAsFormUrlEncoded) {
            p = ScalaCompatibility.parseBody((AnyContentAsFormUrlEncoded)body);
        }
        if (p != null) {
            parameters.putAll(p);
        }
        if ((urlParameters = this.javaRequest.queryString()) != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    protected Object getBody() {
        if (this.scalaRequest != null && this.scalaRequest.hasBody() && this.scalaRequest instanceof Request) {
            return ((Request)this.scalaRequest).body();
        }
        if (this.javaRequest.hasBody() && this.javaRequest instanceof Http.Request) {
            return ((Http.Request)this.javaRequest).body();
        }
        return null;
    }

    public void setResponseHeader(String name, String value) {
        this.responseHeaders.put(name, value);
    }

    public Optional<String> getResponseHeader(String name) {
        return Optional.ofNullable(this.responseHeaders.get(name));
    }

    public String getServerName() {
        String[] split = this.javaRequest.host().split(":");
        return split[0];
    }

    public int getServerPort() {
        String defaultPort = this.javaRequest.secure() ? "443" : "80";
        String[] split = this.javaRequest.host().split(":");
        String portStr = split.length > 1 ? split[1] : defaultPort;
        return Integer.parseInt(portStr);
    }

    public String getScheme() {
        if (this.javaRequest.secure()) {
            return "https";
        }
        return "http";
    }

    public boolean isSecure() {
        return this.javaRequest.secure();
    }

    public String getFullRequestURL() {
        return this.getScheme() + "://" + this.javaRequest.host() + this.javaRequest.uri();
    }

    public String getRemoteAddr() {
        return this.javaRequest.remoteAddress();
    }

    public Optional<Object> getRequestAttribute(String name) {
        Map attributes = this.javaRequest.attrs().getOptional(PAC4J_REQUEST_ATTRIBUTES).orElse(new HashMap());
        return Optional.ofNullable(attributes.get(name));
    }

    public void setRequestAttribute(String name, Object value) {
        Map attributes = this.javaRequest.attrs().getOptional(PAC4J_REQUEST_ATTRIBUTES).orElse(new HashMap());
        attributes.put(name, value);
        this.javaRequest = this.javaRequest.addAttr(PAC4J_REQUEST_ATTRIBUTES, (Object)attributes);
    }

    public Collection<Cookie> getRequestCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Http.Cookies httpCookies = this.javaRequest.cookies();
        httpCookies.forEach(httpCookie -> {
            Cookie cookie = new Cookie(httpCookie.name(), httpCookie.value());
            if (httpCookie.domain() != null) {
                cookie.setDomain(httpCookie.domain());
            }
            cookie.setHttpOnly(httpCookie.httpOnly());
            if (httpCookie.maxAge() != null) {
                cookie.setMaxAge(httpCookie.maxAge().intValue());
            }
            cookie.setPath(httpCookie.path());
            cookie.setSecure(httpCookie.secure());
            cookies.add(cookie);
        });
        return cookies;
    }

    public String getPath() {
        return this.javaRequest.path();
    }

    public void addResponseCookie(Cookie cookie) {
        Http.CookieBuilder cookieBuilder = Http.Cookie.builder((String)cookie.getName(), (String)cookie.getValue()).withPath(cookie.getPath()).withDomain(cookie.getDomain()).withSecure(cookie.isSecure()).withHttpOnly(cookie.isHttpOnly());
        int maxAge = cookie.getMaxAge();
        if (maxAge != -1) {
            cookieBuilder.withMaxAge(Duration.of(maxAge, ChronoUnit.SECONDS));
        }
        Http.Cookie responseCookie = cookieBuilder.build();
        this.responseCookies.add(responseCookie);
    }

    public void setResponseContentType(String contentType) {
        this.responseContentType = contentType;
    }

    public String getRequestContent() {
        if (this.requestContent == null) {
            Object body = this.getBody();
            if (body instanceof Http.RequestBody) {
                this.requestContent = ((Http.RequestBody)body).asText();
            } else if (body instanceof AnyContentAsText) {
                this.requestContent = (String)((AnyContentAsText)body).asText().getOrElse(null);
            }
        }
        return this.requestContent;
    }

    public Http.Session getNativeSession() {
        return this.session;
    }

    public void setNativeSession(Http.Session session) {
        this.session = session;
    }

    public Http.Request supplementRequest(Http.Request request) {
        this.logger.trace("supplement request with: {} and session: {}", (Object)this.javaRequest.attrs(), (Object)this.session);
        return request.withAttrs(this.javaRequest.attrs()).addAttr(RequestAttrKey.Session().asJava(), (Object)new AssignedCell((Object)this.session.asScala()));
    }

    public Http.RequestHeader supplementRequest(Http.RequestHeader request) {
        this.logger.trace("supplement request with: {} and session: {}", (Object)this.javaRequest.attrs(), (Object)this.session);
        return request.withAttrs(this.javaRequest.attrs()).addAttr(RequestAttrKey.Session().asJava(), (Object)new AssignedCell((Object)this.session.asScala()));
    }

    public Result supplementResponse(Result result) {
        Result r = result;
        if (this.responseCookies.size() > 0) {
            this.logger.trace("supplement response with cookies: {}", this.responseCookies);
            r = r.withCookies(this.responseCookies.toArray(new Http.Cookie[this.responseCookies.size()]));
            this.responseCookies.clear();
        }
        if (this.responseHeaders.size() > 0) {
            for (Map.Entry<String, String> header : this.responseHeaders.entrySet()) {
                this.logger.trace("supplement response with header: {}", header);
                r = r.withHeader(header.getKey(), header.getValue());
            }
            this.responseHeaders.clear();
        }
        if (this.responseContentType != null) {
            this.logger.trace("supplement response with type: {}", (Object)this.responseContentType);
            r = r.as(this.responseContentType);
            this.responseContentType = null;
        }
        this.logger.trace("supplement response with session: {}", (Object)this.session);
        r = r.withSession(this.session);
        return r;
    }

    public play.api.mvc.Result supplementResponse(play.api.mvc.Result result) {
        return this.supplementResponse(result.asJava()).asScala();
    }
}

