/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.context.PlayContextFactory;
import org.pac4j.play.http.PlayHttpActionAdapter;
import org.pac4j.play.java.Secure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class SecureAction
extends Action<Result> {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SecurityLogic securityLogic;
    protected static final Method CLIENTS_METHOD;
    protected static final Method AUTHORIZERS_METHOD;
    protected static final Method MATCHERS_METHOD;
    private final Config config;
    private final SessionStore sessionStore;

    @Inject
    public SecureAction(Config config, SessionStore sessionStore) {
        this.config = config;
        this.sessionStore = sessionStore;
    }

    public CompletionStage<Result> call(Http.Request req) {
        try {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.configuration);
            String clients = this.getStringParam(invocationHandler, CLIENTS_METHOD, null);
            String authorizers = this.getStringParam(invocationHandler, AUTHORIZERS_METHOD, null);
            String matchers = this.getStringParam(invocationHandler, MATCHERS_METHOD, null);
            WebContext context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)PlayContextFactory.INSTANCE).newContext(new Object[]{req});
            return this.internalCall(req, context, this.sessionStore, clients, authorizers, matchers);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public CompletionStage<Result> call(WebContext webContext, SessionStore sessionStore, String clients, String authorizers, String matchers) throws Throwable {
        return this.internalCall(null, webContext, sessionStore, clients, authorizers, matchers);
    }

    protected CompletionStage<Result> internalCall(Http.Request req, WebContext webContext, SessionStore sessionStore, String clients, String authorizers, String matchers) throws Throwable {
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)PlayHttpActionAdapter.INSTANCE);
        SecurityLogic bestLogic = FindBest.securityLogic((SecurityLogic)this.securityLogic, (Config)this.config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        HttpActionAdapter actionAdapterWrapper = (action, webCtx) -> CompletableFuture.completedFuture(bestAdapter.adapt(action, webCtx));
        return (CompletionStage)bestLogic.perform(webContext, sessionStore, this.config, (webCtx, session, profiles, parameters) -> {
            if (this.delegate == null) {
                return CompletableFuture.completedFuture(null);
            }
            PlayWebContext playWebContext = (PlayWebContext)webCtx;
            return this.delegate.call(playWebContext.supplementRequest(req));
        }, actionAdapterWrapper, clients, authorizers, matchers, new Object[0]);
    }

    protected String getStringParam(InvocationHandler invocationHandler, Method method, String defaultValue) throws Throwable {
        String value = (String)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        this.logger.debug("String param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    protected boolean getBooleanParam(InvocationHandler invocationHandler, Method method, boolean defaultValue) throws Throwable {
        Boolean value = (Boolean)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        this.logger.debug("Boolean param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
    }

    static {
        try {
            CLIENTS_METHOD = Secure.class.getDeclaredMethod("clients", new Class[0]);
            AUTHORIZERS_METHOD = Secure.class.getDeclaredMethod("authorizers", new Class[0]);
            MATCHERS_METHOD = Secure.class.getDeclaredMethod("matchers", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

