/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.inject.Singleton;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.serializer.JavaSerializer;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.store.DataEncrypter;
import org.pac4j.play.store.ShiroAesDataEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;

@Singleton
public class PlayCookieSessionStore
implements SessionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayCookieSessionStore.class);
    private String sessionName = "pac4j";
    private DataEncrypter dataEncrypter = new ShiroAesDataEncrypter();
    public static final JavaSerializer JAVA_SERIALIZER = new JavaSerializer();

    public PlayCookieSessionStore() {
    }

    public PlayCookieSessionStore(DataEncrypter dataEncrypter) {
        this.dataEncrypter = dataEncrypter;
    }

    public Optional<String> getSessionId(WebContext context, boolean createSession) {
        Http.Session session = ((PlayWebContext)context).getNativeSession();
        if (session.get(this.sessionName).isPresent()) {
            return Optional.of(this.sessionName);
        }
        if (createSession) {
            this.putSessionValues(context, new HashMap<String, Object>());
            return Optional.of(this.sessionName);
        }
        return Optional.empty();
    }

    public Optional<Object> get(WebContext context, String key) {
        Map<String, Object> values = this.getSessionValues(context);
        Object value = values.get(key);
        if (value instanceof Exception) {
            LOGGER.debug("Get value: {} for key: {}", (Object)value.toString(), (Object)key);
        } else {
            LOGGER.debug("Get value: {} for key: {}", value, (Object)key);
        }
        return Optional.ofNullable(value);
    }

    protected Map<String, Object> getSessionValues(WebContext context) {
        Http.Session session = ((PlayWebContext)context).getNativeSession();
        String sessionValue = session.get(this.sessionName).orElse(null);
        Map values = null;
        if (sessionValue != null) {
            byte[] inputBytes = Base64.getDecoder().decode(sessionValue);
            values = (Map)JAVA_SERIALIZER.deserializeFromBytes(PlayCookieSessionStore.uncompressBytes(this.dataEncrypter.decrypt(inputBytes)));
        }
        if (values != null) {
            return values;
        }
        return new HashMap<String, Object>();
    }

    public void set(WebContext context, String key, Object value) {
        if (value instanceof Exception) {
            LOGGER.debug("set key: {} with value: {}", (Object)key, (Object)value.toString());
        } else {
            LOGGER.debug("set key: {}, with value: {}", (Object)key, value);
        }
        Map<String, Object> values = this.getSessionValues(context);
        if (value == null) {
            values.remove(key);
        } else {
            Object clearedValue = value;
            if ("pac4jUserProfiles".equals(key)) {
                clearedValue = this.clearUserProfiles(value);
            }
            values.put(key, clearedValue);
        }
        this.putSessionValues(context, values);
    }

    protected void putSessionValues(WebContext context, Map<String, Object> values) {
        String serialized = null;
        if (values != null) {
            byte[] javaSerBytes = JAVA_SERIALIZER.serializeToBytes(values);
            serialized = Base64.getEncoder().encodeToString(this.dataEncrypter.encrypt(PlayCookieSessionStore.compressBytes(javaSerBytes)));
        }
        if (serialized != null) {
            LOGGER.trace("serialized token size = {}", (Object)serialized.length());
        } else {
            LOGGER.trace("-> null serialized token");
        }
        PlayWebContext playWebContext = (PlayWebContext)context;
        if (serialized == null) {
            playWebContext.setNativeSession(playWebContext.getNativeSession().removing(new String[]{this.sessionName}));
        } else {
            playWebContext.setNativeSession(playWebContext.getNativeSession().adding(this.sessionName, serialized));
        }
    }

    public boolean destroySession(WebContext context) {
        this.putSessionValues(context, null);
        return true;
    }

    public Optional<Object> getTrackableSession(WebContext context) {
        return Optional.empty();
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        return false;
    }

    protected Object clearUserProfiles(Object value) {
        LinkedHashMap profiles = (LinkedHashMap)value;
        profiles.forEach((name, profile) -> profile.removeLoginData());
        return profiles;
    }

    public static byte[] uncompressBytes(byte[] zippedBytes) {
        byte[] byArray;
        ByteArrayOutputStream resultBao = new ByteArrayOutputStream();
        GZIPInputStream zipInputStream = new GZIPInputStream(new ByteArrayInputStream(zippedBytes));
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = zipInputStream.read(buffer)) > 0) {
                resultBao.write(buffer, 0, len);
            }
            byArray = resultBao.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Unable to uncompress session cookie", (Throwable)e);
                return null;
            }
        }
        zipInputStream.close();
        return byArray;
    }

    public static byte[] compressBytes(byte[] srcBytes) {
        ByteArrayOutputStream resultBao = new ByteArrayOutputStream();
        try (GZIPOutputStream zipOutputStream = new GZIPOutputStream(resultBao);){
            zipOutputStream.write(srcBytes);
        }
        catch (IOException e) {
            LOGGER.error("Unable to compress session cookie", (Throwable)e);
            return null;
        }
        return resultBao.toByteArray();
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }
}

