/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import java.security.SecureRandom;
import org.apache.shiro.crypto.AesCipherService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.store.DataEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAesDataEncrypter
implements DataEncrypter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AesCipherService aesCipherService = new AesCipherService();
    private byte[] key;

    public ShiroAesDataEncrypter(byte[] key) {
        CommonHelper.assertNotNull((String)"key", (Object)key);
        this.key = (byte[])key.clone();
    }

    public ShiroAesDataEncrypter() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        this.key = bytes;
    }

    @Override
    public byte[] decrypt(byte[] encryptedBytes) {
        if (encryptedBytes == null) {
            return null;
        }
        return this.aesCipherService.decrypt(encryptedBytes, this.key).getBytes();
    }

    @Override
    public byte[] encrypt(byte[] rawBytes) {
        if (rawBytes == null) {
            return null;
        }
        return this.aesCipherService.encrypt(rawBytes, this.key).getBytes();
    }
}

