/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.barbican.Container;
import org.openstack4j.model.barbican.ContainerConsumer;
import org.openstack4j.model.barbican.ContainerSecret;
import org.openstack4j.model.barbican.builder.ContainerCreateBuilder;
import org.openstack4j.openstack.barbican.domain.BarbicanContainerConsumer;
import org.openstack4j.openstack.barbican.domain.BarbicanContainerSecret;
import org.openstack4j.openstack.common.ListResult;

public class BarbicanContainer
implements Container {
    private static final long serialVersionUID = 1L;
    private String status;
    @JsonProperty(value="updated")
    private Date updatedTime;
    @JsonProperty(value="created")
    private Date createdTime;
    private String name;
    private List<BarbicanContainerConsumer> consumers;
    @JsonProperty(value="container_ref")
    private String containerReference;
    @JsonProperty(value="creator_id")
    private String creatorId;
    @JsonProperty(value="secret_refs")
    private List<BarbicanContainerSecret> secretReferences;
    private String type;

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends ContainerConsumer> getConsumers() {
        return this.consumers;
    }

    @Override
    public String getContainerReference() {
        return this.containerReference;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public List<? extends ContainerSecret> getSecretReferences() {
        return this.secretReferences;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("status", (Object)this.status).add("name", (Object)this.name).add("updated", (Object)this.updatedTime).add("created", (Object)this.createdTime).add("consumers", this.consumers).add("reference", (Object)this.containerReference).add("creatorId", (Object)this.creatorId).add("secrets", this.secretReferences).add("type", (Object)this.type).toString();
    }

    @Override
    public ContainerCreateBuilder toBuilder() {
        return new ContainerCreateConcreteBuilder();
    }

    public static ContainerCreateBuilder builder() {
        return new ContainerCreateConcreteBuilder();
    }

    public static class ContainerCreateConcreteBuilder
    implements ContainerCreateBuilder {
        private BarbicanContainer internalContainer;

        public ContainerCreateConcreteBuilder() {
            this(new BarbicanContainer());
        }

        public ContainerCreateConcreteBuilder(BarbicanContainer container) {
            this.internalContainer = container;
        }

        @Override
        public Container build() {
            return this.internalContainer;
        }

        @Override
        public ContainerCreateBuilder from(Container in) {
            this.internalContainer = (BarbicanContainer)in;
            return this;
        }

        @Override
        public ContainerCreateBuilder name(String name) {
            this.internalContainer.name = name;
            return this;
        }

        @Override
        public ContainerCreateBuilder type(String type) {
            this.internalContainer.type = type;
            return this;
        }

        @Override
        public ContainerCreateBuilder secretReferences(List<? extends ContainerSecret> references) {
            this.internalContainer.secretReferences = references;
            return this;
        }
    }

    public static class Containers
    extends ListResult<BarbicanContainer> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="total")
        private int count;
        @JsonProperty(value="containers")
        private List<BarbicanContainer> list;

        @Override
        protected List<BarbicanContainer> value() {
            return this.list;
        }

        public int getCount() {
            return this.count;
        }
    }
}

