/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.client;

import com.google.common.base.Preconditions;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.api.types.Facing;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.openstack.identity.v2.domain.Credentials;
import org.openstack4j.openstack.identity.v2.domain.RaxApiKeyCredentials;
import org.openstack4j.openstack.identity.v2.domain.TokenAuth;
import org.openstack4j.openstack.identity.v3.domain.KeystoneAuth;
import org.openstack4j.openstack.internal.OSAuthenticator;

public abstract class OSClientBuilder<R, T extends IOSClientBuilder<R, T>>
implements IOSClientBuilder<R, T> {
    Config config;
    String endpoint;
    String user;
    String password;
    Facing perspective;
    CloudProvider provider = CloudProvider.UNKNOWN;

    @Override
    public T withConfig(Config config) {
        this.config = config;
        return (T)this;
    }

    @Override
    public T provider(CloudProvider provider) {
        this.provider = provider;
        return (T)this;
    }

    @Override
    public T credentials(String user, String password) {
        this.user = user;
        this.password = password;
        return (T)this;
    }

    @Override
    public T endpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)this;
    }

    @Override
    public T perspective(Facing perspective) {
        this.perspective = perspective;
        return (T)this;
    }

    @Override
    public T useNonStrictSSLClient(boolean useNonStrictSSL) {
        if (this.config == null) {
            this.config = Config.newConfig().withSSLVerificationDisabled();
        }
        return (T)this;
    }

    public static class ClientV3
    extends OSClientBuilder<OSClient.OSClientV3, IOSClientBuilder.V3>
    implements IOSClientBuilder.V3 {
        Identifier domain;
        KeystoneAuth.AuthScope scope;
        String tokenId;

        @Override
        public ClientV3 domainName(String domainName) {
            this.domain = Identifier.byName(domainName);
            return this;
        }

        @Override
        public ClientV3 domainId(String domainId) {
            this.domain = Identifier.byId(domainId);
            return this;
        }

        @Override
        public ClientV3 credentials(String user, String password, Identifier domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
            return this;
        }

        @Override
        public ClientV3 token(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        @Override
        public OSClient.OSClientV3 authenticate() throws AuthenticationException {
            if (this.tokenId != null && this.tokenId.length() > 0) {
                return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.tokenId, this.scope), this.endpoint, this.perspective, this.config, this.provider);
            }
            return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.user, this.password, this.domain, this.scope), this.endpoint, this.perspective, this.config, this.provider);
        }

        @Override
        public ClientV3 scopeToProject(Identifier project, Identifier domain) {
            this.scope = KeystoneAuth.AuthScope.project(project, domain);
            return this;
        }

        @Override
        public ClientV3 scopeToProject(Identifier project) {
            this.scope = KeystoneAuth.AuthScope.project(project);
            return this;
        }

        @Override
        public ClientV3 scopeToDomain(Identifier domain) {
            this.scope = KeystoneAuth.AuthScope.domain(domain);
            return this;
        }
    }

    public static class ClientV2
    extends OSClientBuilder<OSClient.OSClientV2, IOSClientBuilder.V2>
    implements IOSClientBuilder.V2 {
        String tenantName;
        String tenantId;
        String tokenId;
        boolean raxApiKey;

        @Override
        public ClientV2 tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        @Override
        public ClientV2 tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public ClientV2 raxApiKey(boolean raxApiKey) {
            this.raxApiKey = raxApiKey;
            return this;
        }

        @Override
        public OSClient.OSClientV2 authenticate() throws AuthenticationException {
            if (this.tokenId != null) {
                Preconditions.checkArgument((this.tenantName != null || this.tenantId != null ? 1 : 0) != 0, (Object)"TenantId or TenantName is required when using Token Auth");
                return (OSClient.OSClientV2)OSAuthenticator.invoke(new TokenAuth(this.tokenId, this.tenantName, this.tenantId), this.endpoint, this.perspective, this.config, this.provider);
            }
            if (this.raxApiKey) {
                return (OSClient.OSClientV2)OSAuthenticator.invoke(new RaxApiKeyCredentials(this.user, this.password), this.endpoint, this.perspective, this.config, this.provider);
            }
            return (OSClient.OSClientV2)OSAuthenticator.invoke(new Credentials(this.user, this.password, this.tenantName, this.tenantId), this.endpoint, this.perspective, this.config, this.provider);
        }

        @Override
        public ClientV2 token(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }
    }
}

